"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MatrixHistogramComponent = exports.MatrixHistogram = void 0;
var _react = _interopRequireWildcard(require("react"));
var _styled = _interopRequireDefault(require("@emotion/styled"));
var _eui = require("@elastic/eui");
var _fp = require("lodash/fp");
var i18n = _interopRequireWildcard(require("./translations"));
var _header_section = require("../header_section");
var _panel = require("../panel");
var _hover_visibility_container = require("../hover_visibility_container");
var _query_toggle = require("../../containers/query_toggle");
var _utils = require("../visualization_actions/utils");
var _visualization_embeddable = require("../visualization_actions/visualization_embeddable");
var _use_visualization_response = require("../visualization_actions/use_visualization_response");
var _histogram_configurations = require("../events_tab/histogram_configurations");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/common/components/matrix_histogram/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const DEFAULT_PANEL_HEIGHT = 300;
const HistogramPanel = (0, _styled.default)(_panel.Panel)`
  display: flex;
  flex-direction: column;
  ${({
  height
}) => height != null ? `min-height: ${height}px;` : ''}
`;
const CHART_HEIGHT = 150;
const MatrixHistogramComponent = ({
  chartHeight,
  defaultStackByOption,
  endDate,
  filterQuery,
  getLensAttributes,
  headerChildren,
  hideHistogramIfEmpty = false,
  id,
  isPtrIncluded,
  lensAttributes,
  paddingSize = 'm',
  panelHeight = DEFAULT_PANEL_HEIGHT,
  showSpacer = true,
  stackByOptions,
  startDate,
  subtitle,
  sourcererScopeId,
  title,
  titleSize,
  hideQueryToggle = false,
  applyGlobalQueriesAndFilters = true
}) => {
  const visualizationId = `${id}-embeddable`;
  const [isInitialLoading, setIsInitialLoading] = (0, _react.useState)(true);
  const [selectedStackByOption, setSelectedStackByOption] = (0, _react.useState)(defaultStackByOption);
  (0, _react.useEffect)(() => {
    setSelectedStackByOption(defaultStackByOption);
  }, [defaultStackByOption]);
  const setSelectedChartOptionCallback = (0, _react.useCallback)(event => {
    var _stackByOptions$find;
    setSelectedStackByOption((_stackByOptions$find = stackByOptions.find(co => co.value === event.target.value)) !== null && _stackByOptions$find !== void 0 ? _stackByOptions$find : defaultStackByOption);
  }, [defaultStackByOption, stackByOptions]);
  const {
    toggleStatus,
    setToggleStatus
  } = (0, _query_toggle.useQueryToggle)(id);
  const toggleQuery = (0, _react.useCallback)(status => {
    setToggleStatus(status);
  }, [setToggleStatus]);
  const titleWithStackByField = (0, _react.useMemo)(() => title != null && typeof title === 'function' ? title(selectedStackByOption) : title, [title, selectedStackByOption]);
  const {
    tables
  } = (0, _use_visualization_response.useVisualizationResponse)({
    visualizationId
  });
  const visualizationTotalCount = tables && tables.meta.statistics.totalCount;
  const subtitleWithCounts = (0, _react.useMemo)(() => {
    if (isInitialLoading) {
      return undefined;
    }
    if (typeof subtitle === 'function') {
      return visualizationTotalCount ? subtitle(visualizationTotalCount) : undefined;
    }
    return subtitle;
  }, [isInitialLoading, subtitle, visualizationTotalCount]);
  const hideHistogram = (0, _react.useMemo)(() => (visualizationTotalCount !== null && visualizationTotalCount !== void 0 ? visualizationTotalCount : 0) === 0 && hideHistogramIfEmpty ? true : false, [hideHistogramIfEmpty, visualizationTotalCount]);
  (0, _react.useEffect)(() => {
    if (isInitialLoading && tables) {
      setIsInitialLoading(false);
    }
  }, [isInitialLoading, tables]);
  const timerange = (0, _react.useMemo)(() => ({
    from: startDate,
    to: endDate
  }), [startDate, endDate]);
  const extraVisualizationOptions = (0, _react.useMemo)(() => ({
    dnsIsPtrIncluded: isPtrIncluded !== null && isPtrIncluded !== void 0 ? isPtrIncluded : false,
    filters: filterQuery ? [{
      query: (0, _fp.isString)(filterQuery) ? JSON.parse(filterQuery) : filterQuery,
      meta: {}
    }] : undefined
  }), [isPtrIncluded, filterQuery]);

  // If the user selected the `No breakdown` option, we shouldn't perform the aggregation
  const stackByField = (0, _react.useMemo)(() => {
    return selectedStackByOption.value === _histogram_configurations.NO_BREAKDOWN_STACK_BY_VALUE ? undefined : selectedStackByOption.value;
  }, [selectedStackByOption.value]);
  if (hideHistogram) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_hover_visibility_container.HoverVisibilityContainer, {
    show: !isInitialLoading,
    targetClassNames: [_utils.VISUALIZATION_ACTIONS_BUTTON_CLASS],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 161,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(HistogramPanel, {
    "data-test-subj": `${id}Panel`,
    height: toggleStatus ? panelHeight : undefined,
    paddingSize: paddingSize,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 165,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_header_section.HeaderSection, {
    id: id,
    height: toggleStatus ? undefined : 0,
    title: titleWithStackByField,
    titleSize: titleSize,
    toggleStatus: toggleStatus,
    toggleQuery: hideQueryToggle ? undefined : toggleQuery,
    subtitle: subtitleWithCounts,
    showInspectButton: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 170,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 180,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 181,
      columnNumber: 15
    }
  }, stackByOptions.length > 1 && /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    onChange: setSelectedChartOptionCallback,
    options: stackByOptions,
    prepend: i18n.STACK_BY,
    value: selectedStackByOption === null || selectedStackByOption === void 0 ? void 0 : selectedStackByOption.value,
    "aria-label": i18n.STACK_BY,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 183,
      columnNumber: 19
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 192,
      columnNumber: 15
    }
  }, headerChildren))), toggleStatus ? /*#__PURE__*/_react.default.createElement(_visualization_embeddable.VisualizationEmbeddable, {
    scopeId: sourcererScopeId,
    applyGlobalQueriesAndFilters: applyGlobalQueriesAndFilters,
    "data-test-subj": "embeddable-matrix-histogram",
    extraOptions: extraVisualizationOptions,
    getLensAttributes: getLensAttributes,
    height: chartHeight !== null && chartHeight !== void 0 ? chartHeight : CHART_HEIGHT,
    id: visualizationId,
    inspectTitle: title,
    lensAttributes: lensAttributes,
    stackByField: stackByField,
    timerange: timerange,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 196,
      columnNumber: 13
    }
  }) : null)), showSpacer && /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    "data-test-subj": "spacer",
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 212,
      columnNumber: 22
    }
  }));
};
exports.MatrixHistogramComponent = MatrixHistogramComponent;
const MatrixHistogram = exports.MatrixHistogram = /*#__PURE__*/_react.default.memo(MatrixHistogramComponent);