"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SettingsFlyout = exports.DEFAULT_STACK_BY_FIELD = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _elasticAssistant = require("@kbn/elastic-assistant");
var _elasticAssistantCommon = require("@kbn/elastic-assistant-common");
var _footer = require("./footer");
var i18n = _interopRequireWildcard(require("./translations"));
var _use_tabs_view = require("./hooks/use_tabs_view");
var _constants = require("./constants");
var _get_max_alerts = require("./alert_selection/helpers/get_max_alerts");
var _helpers = require("../helpers");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/attack_discovery/pages/settings_flyout/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const DEFAULT_STACK_BY_FIELD = exports.DEFAULT_STACK_BY_FIELD = 'kibana.alert.rule.name';
const SettingsFlyoutComponent = ({
  connectorId,
  defaultSelectedTabId,
  end,
  filters,
  localStorageAttackDiscoveryMaxAlerts,
  onClose,
  onConnectorIdSelected,
  onGenerate,
  query,
  setEnd,
  setFilters,
  setLocalStorageAttackDiscoveryMaxAlerts,
  setQuery,
  setStart,
  start
}) => {
  const flyoutTitleId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'attackDiscoverySettingsFlyoutTitle'
  });
  const [settings, setSettings] = (0, _react.useState)({
    end: end !== null && end !== void 0 ? end : _elasticAssistantCommon.DEFAULT_END,
    filters: filters !== null && filters !== void 0 ? filters : [],
    query: query !== null && query !== void 0 ? query : (0, _helpers.getDefaultQuery)(),
    size: (0, _get_max_alerts.getMaxAlerts)(localStorageAttackDiscoveryMaxAlerts !== null && localStorageAttackDiscoveryMaxAlerts !== void 0 ? localStorageAttackDiscoveryMaxAlerts : `${_elasticAssistant.DEFAULT_ATTACK_DISCOVERY_MAX_ALERTS}`),
    start: start !== null && start !== void 0 ? start : _elasticAssistantCommon.DEFAULT_START
  });
  const onSettingsReset = (0, _react.useCallback)(() => {
    // reset local state:
    setSettings({
      end: _elasticAssistantCommon.DEFAULT_END,
      filters: [],
      query: (0, _helpers.getDefaultQuery)(),
      size: (0, _get_max_alerts.getMaxAlerts)(`${_elasticAssistant.DEFAULT_ATTACK_DISCOVERY_MAX_ALERTS}`),
      start: _elasticAssistantCommon.DEFAULT_START
    });
  }, []);
  const onSettingsSave = (0, _react.useCallback)(() => {
    // copy local state:
    setEnd(settings.end);
    setFilters(settings.filters);
    setQuery(settings.query);
    setStart(settings.start);
    setLocalStorageAttackDiscoveryMaxAlerts(`${settings.size}`);
    onClose();
  }, [onClose, setEnd, setFilters, setLocalStorageAttackDiscoveryMaxAlerts, setQuery, setStart, settings]);
  const {
    tabsContainer,
    actionButtons: tabsActionButtons
  } = (0, _use_tabs_view.useTabsView)({
    connectorId,
    defaultSelectedTabId,
    onConnectorIdSelected,
    onGenerate,
    onSettingsReset,
    onSettingsSave,
    onSettingsChanged: setSettings,
    settings
  });
  const title = defaultSelectedTabId === _constants.SCHEDULE_TAB_ID ? i18n.ATTACK_DISCOVERY_SCHEDULE : i18n.ATTACK_DISCOVERY_SETTINGS;
  const closeButtonText = defaultSelectedTabId !== _constants.SCHEDULE_TAB_ID ? i18n.CANCEL : undefined;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutResizable, {
    "aria-labelledby": flyoutTitleId,
    "data-test-subj": "settingsFlyout",
    minWidth: _constants.MIN_FLYOUT_WIDTH,
    onClose: onClose,
    paddingSize: "l",
    side: "right",
    size: "m",
    type: "overlay",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 130,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 140,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    "data-test-subj": "title",
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 141,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    id: flyoutTitleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 142,
      columnNumber: 11
    }
  }, title))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 146,
      columnNumber: 7
    }
  }, tabsContainer), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 148,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_footer.Footer, {
    actionButtons: tabsActionButtons,
    closeButtonText: closeButtonText,
    closeModal: onClose,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 149,
      columnNumber: 9
    }
  })));
};
SettingsFlyoutComponent.displayName = 'SettingsFlyoutComponent';
const SettingsFlyout = exports.SettingsFlyout = /*#__PURE__*/_react.default.memo(SettingsFlyoutComponent);