"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EndpointSuggestionsSchema = void 0;
var _configSchema = require("@kbn/config-schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EndpointSuggestionsSchema = exports.EndpointSuggestionsSchema = {
  body: _configSchema.schema.object({
    field: _configSchema.schema.string(),
    query: _configSchema.schema.string(),
    filters: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.object({}, {
      unknowns: 'allow'
    }))),
    fieldMeta: _configSchema.schema.maybe(_configSchema.schema.any())
  }),
  params: _configSchema.schema.object({
    suggestion_type: _configSchema.schema.oneOf([_configSchema.schema.literal('eventFilters'), _configSchema.schema.literal('endpoints'), _configSchema.schema.literal('trustedApps'), _configSchema.schema.literal('trustedDevices')])
  })
};