"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.validateCreateRuleProps = void 0;
var _threshold = require("../../../../../utils/request_validation/threshold");
var _indicator_match = require("../../../../../utils/request_validation/indicator_match");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Additional validation that is implemented outside of the schema itself.
 */
const validateCreateRuleProps = props => {
  return [...validateTimelineId(props), ...validateTimelineTitle(props), ...validateThreatMatchConcurrentSearches(props), ...validateThreshold(props), ...(0, _indicator_match.validateThreatMapping)(props)];
};
exports.validateCreateRuleProps = validateCreateRuleProps;
const validateTimelineId = props => {
  if (props.timeline_id != null) {
    if (props.timeline_title == null) {
      return ['when "timeline_id" exists, "timeline_title" must also exist'];
    } else if (props.timeline_id === '') {
      return ['"timeline_id" cannot be an empty string'];
    } else {
      return [];
    }
  }
  return [];
};
const validateTimelineTitle = props => {
  if (props.timeline_title != null) {
    if (props.timeline_id == null) {
      return ['when "timeline_title" exists, "timeline_id" must also exist'];
    } else if (props.timeline_title === '') {
      return ['"timeline_title" cannot be an empty string'];
    } else {
      return [];
    }
  }
  return [];
};
const validateThreatMatchConcurrentSearches = props => {
  const errors = [];
  if (props.type === 'threat_match') {
    if (props.concurrent_searches != null && props.items_per_search == null) {
      errors.push('when "concurrent_searches" exists, "items_per_search" must also exist');
    }
    if (props.concurrent_searches == null && props.items_per_search != null) {
      errors.push('when "items_per_search" exists, "concurrent_searches" must also exist');
    }
  }
  return errors;
};
const validateThreshold = props => (0, _threshold.validateThresholdBase)(props);