"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SpaceColumnHeader = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _securityRoleManagementModel = require("@kbn/security-role-management-model");
var _spaces_popover_list = require("../../../spaces_popover_list");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/security/public/management/roles/edit_role/privileges/kibana/privilege_summary/space_column_header.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const SPACES_DISPLAY_COUNT = 4;
const SpaceColumnHeader = props => {
  const {
    spacesApiUi
  } = props;
  const isGlobal = (0, _securityRoleManagementModel.isGlobalPrivilegeDefinition)(props.entry);
  const entrySpaces = props.entry.spaces.map(spaceId => {
    var _props$spaces$find;
    return (_props$spaces$find = props.spaces.find(s => s.id === spaceId)) !== null && _props$spaces$find !== void 0 ? _props$spaces$find : {
      id: spaceId,
      name: spaceId,
      disabledFeatures: []
    };
  });
  const LazySpaceAvatar = (0, _react.useMemo)(() => spacesApiUi.components.getSpaceAvatar, [spacesApiUi]);
  return /*#__PURE__*/_react.default.createElement("div", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 41,
      columnNumber: 5
    }
  }, entrySpaces.slice(0, SPACES_DISPLAY_COUNT).map(space => {
    return /*#__PURE__*/_react.default.createElement("span", {
      key: space.id,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 44,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(LazySpaceAvatar, {
      size: "s",
      space: space,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 45,
        columnNumber: 13
      }
    }), ' ', isGlobal && /*#__PURE__*/_react.default.createElement("span", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 47,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.management.editRole.spacePrivilegeMatrix.globalSpaceName",
      defaultMessage: "All Spaces",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 48,
        columnNumber: 17
      }
    })));
  }), entrySpaces.length > SPACES_DISPLAY_COUNT && /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("br", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_spaces_popover_list.SpacesPopoverList, {
    spaces: entrySpaces,
    buttonText: _i18n.i18n.translate('xpack.security.management.editRole.spacePrivilegeMatrix.showNMoreSpacesLink', {
      defaultMessage: '+{count} more',
      values: {
        count: entrySpaces.length - SPACES_DISPLAY_COUNT
      }
    }),
    spacesApiUi: spacesApiUi,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 11
    }
  })));
};
exports.SpaceColumnHeader = SpaceColumnHeader;