"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useBadge = useBadge;
var _react = require("react");
var _public = require("@kbn/kibana-react-plugin/public");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Renders a badge in the Kibana chrome.
 * @param badge Params of the badge or `undefined` to render no badge.
 * @param badge.iconType Icon type of the badge shown in the Kibana chrome.
 * @param badge.text Title of tooltip displayed when hovering the badge.
 * @param badge.tooltip Description of tooltip displayed when hovering the badge.
 * @param deps If present, badge will be updated or removed if the values in the list change.
 */
function useBadge(badge, deps = [badge === null || badge === void 0 ? void 0 : badge.iconType, badge === null || badge === void 0 ? void 0 : badge.text, badge === null || badge === void 0 ? void 0 : badge.tooltip]) {
  const {
    services
  } = (0, _public.useKibana)();
  (0, _react.useEffect)(() => {
    if (badge) {
      services.chrome.setBadge(badge);
      return () => services.chrome.setBadge();
    }
  }, deps); // eslint-disable-line react-hooks/exhaustive-deps
}