"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LoginPage = void 0;
exports.renderLoginPage = renderLoginPage;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _react2 = _interopRequireWildcard(require("react"));
var _reactDom = _interopRequireDefault(require("react-dom"));
var _rxjs = require("rxjs");
var _full_screen_bg_css = require("@kbn/css-utils/public/full_screen_bg_css");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _components = require("./components");
var _constants = require("../../../common/constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/security/public/authentication/login/login_page.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const loginFormMessages = {
  SESSION_EXPIRED: {
    type: _components.LoginFormMessageType.Info,
    content: _i18n.i18n.translate('xpack.security.login.sessionExpiredDescription', {
      defaultMessage: 'Your session has timed out. Please log in again.'
    })
  },
  CONCURRENCY_LIMIT: {
    type: _components.LoginFormMessageType.Info,
    content: _i18n.i18n.translate('xpack.security.login.concurrencyLimitDescription', {
      defaultMessage: 'You have logged in on another device. Please log in again.'
    })
  },
  AUTHENTICATION_ERROR: {
    type: _components.LoginFormMessageType.Info,
    content: _i18n.i18n.translate('xpack.security.login.authenticationErrorDescription', {
      defaultMessage: 'An unexpected authentication error occurred. Please log in again.'
    })
  },
  LOGGED_OUT: {
    type: _components.LoginFormMessageType.Info,
    content: _i18n.i18n.translate('xpack.security.login.loggedOutDescription', {
      defaultMessage: 'You have logged out of Elastic.'
    })
  },
  UNAUTHENTICATED: {
    type: _components.LoginFormMessageType.Danger,
    content: _i18n.i18n.translate('xpack.security.unauthenticated.errorDescription', {
      defaultMessage: 'Try logging in again, and if the problem persists, contact your system administrator.'
    })
  }
};
class LoginPage extends _react2.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "state", {
      loginState: null,
      customBranding: {}
    });
    (0, _defineProperty2.default)(this, "customBrandingSubscription", void 0);
    (0, _defineProperty2.default)(this, "getLoginForm", ({
      layout,
      requiresSecureConnection,
      isSecureConnection,
      isCookiesEnabled,
      selector,
      loginHelp
    }) => {
      const isLoginExplicitlyDisabled = selector.providers.length === 0;
      if (isLoginExplicitlyDisabled) {
        return /*#__PURE__*/_react2.default.createElement(_components.DisabledLoginForm, {
          title: /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.security.loginPage.noLoginMethodsAvailableTitle",
            defaultMessage: "Login is disabled.",
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 222,
              columnNumber: 13
            }
          }),
          message: /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.security.loginPage.noLoginMethodsAvailableMessage",
            defaultMessage: "Contact your system administrator.",
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 228,
              columnNumber: 13
            }
          }),
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 220,
            columnNumber: 9
          }
        });
      }
      if (requiresSecureConnection && !isSecureConnection) {
        return /*#__PURE__*/_react2.default.createElement(_components.DisabledLoginForm, {
          title: /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.security.loginPage.requiresSecureConnectionTitle",
            defaultMessage: "A secure connection is required for log in",
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 241,
              columnNumber: 13
            }
          }),
          message: /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.security.loginPage.requiresSecureConnectionMessage",
            defaultMessage: "Contact your system administrator.",
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 247,
              columnNumber: 13
            }
          }),
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 239,
            columnNumber: 9
          }
        });
      }
      if (!isCookiesEnabled) {
        if (isWindowEmbedded()) {
          return /*#__PURE__*/_react2.default.createElement("div", {
            style: {
              maxWidth: '36em',
              margin: 'auto',
              textAlign: 'center'
            },
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 259,
              columnNumber: 11
            }
          }, /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
            color: "subdued",
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 260,
              columnNumber: 13
            }
          }, /*#__PURE__*/_react2.default.createElement("p", {
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 261,
              columnNumber: 15
            }
          }, this.props.sameSiteCookies !== 'None' ? /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.security.loginPage.openInNewWindowOrChangeKibanaConfigTitle",
            defaultMessage: "To view this content, open it in a new window or ask your administrator to allow cross-origin cookies.",
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 263,
              columnNumber: 19
            }
          }) : /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.security.loginPage.openInNewWindowOrChangeBrowserSettingsTitle",
            defaultMessage: "To view this content, open it in a new window or adjust your browser settings to allow third-party cookies.",
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 268,
              columnNumber: 19
            }
          }))), /*#__PURE__*/_react2.default.createElement(_eui.EuiSpacer, {
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 275,
              columnNumber: 13
            }
          }), /*#__PURE__*/_react2.default.createElement(_eui.EuiButton, {
            href: window.location.href,
            target: "_blank",
            iconType: "popout",
            iconSide: "right",
            fill: true,
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 276,
              columnNumber: 13
            }
          }, /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.security.loginPage.openInNewWindowButton",
            defaultMessage: "Open in new window",
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 283,
              columnNumber: 15
            }
          })));
        }
        return /*#__PURE__*/_react2.default.createElement(_components.DisabledLoginForm, {
          title: /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.security.loginPage.requiresCookiesTitle",
            defaultMessage: "Cookies are required to log in to Elastic",
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 295,
              columnNumber: 13
            }
          }),
          message: /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.security.loginPage.requiresCookiesMessage",
            defaultMessage: "Enable cookies in your browser settings to continue.",
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 301,
              columnNumber: 13
            }
          }),
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 293,
            columnNumber: 9
          }
        });
      }
      if (layout === 'error-es-unavailable') {
        return /*#__PURE__*/_react2.default.createElement(_components.DisabledLoginForm, {
          title: /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.security.loginPage.esUnavailableTitle",
            defaultMessage: "Cannot connect to the Elasticsearch cluster",
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 314,
              columnNumber: 13
            }
          }),
          message: /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.security.loginPage.esUnavailableMessage",
            defaultMessage: "See the Kibana logs for details and try reloading the page.",
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 320,
              columnNumber: 13
            }
          }),
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 312,
            columnNumber: 9
          }
        });
      }
      if (layout === 'error-xpack-unavailable') {
        return /*#__PURE__*/_react2.default.createElement(_components.DisabledLoginForm, {
          title: /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.security.loginPage.xpackUnavailableTitle",
            defaultMessage: "Cannot connect to the Elasticsearch cluster currently configured for Kibana.",
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 333,
              columnNumber: 13
            }
          }),
          message: /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.security.loginPage.xpackUnavailableMessage",
            defaultMessage: "To use the full set of free features in this distribution of Kibana, please update Elasticsearch to the default distribution.",
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 339,
              columnNumber: 13
            }
          }),
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 331,
            columnNumber: 9
          }
        });
      }
      if (layout !== 'form') {
        return /*#__PURE__*/_react2.default.createElement(_components.DisabledLoginForm, {
          title: /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.security.loginPage.unknownLayoutTitle",
            defaultMessage: "Unsupported login form layout.",
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 352,
              columnNumber: 13
            }
          }),
          message: /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.security.loginPage.unknownLayoutMessage",
            defaultMessage: "See the Kibana logs for details and try reloading the page.",
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 358,
              columnNumber: 13
            }
          }),
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 350,
            columnNumber: 9
          }
        });
      }
      const {
        searchParams
      } = new URL(window.location.href);
      return /*#__PURE__*/_react2.default.createElement(_components.LoginForm, {
        http: this.props.http,
        notifications: this.props.notifications,
        selector: selector,
        message: loginFormMessages[searchParams.get(_constants.LOGOUT_REASON_QUERY_STRING_PARAMETER)],
        loginAssistanceMessage: this.props.loginAssistanceMessage,
        loginHelp: loginHelp,
        authProviderHint: searchParams.get(_constants.AUTH_PROVIDER_HINT_QUERY_STRING_PARAMETER) || undefined,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 370,
          columnNumber: 7
        }
      });
    });
  }
  async componentDidMount() {
    const loadingCount$ = new _rxjs.BehaviorSubject(1);
    this.customBrandingSubscription = this.props.customBranding.customBranding$.subscribe(next => {
      this.setState({
        ...this.state,
        customBranding: next
      });
    });
    this.props.http.addLoadingCountSource(loadingCount$.asObservable());
    try {
      this.setState({
        loginState: await this.props.http.get('/internal/security/login_state')
      });
    } catch (err) {
      this.props.fatalErrors.add(err);
    }
    loadingCount$.next(0);
    loadingCount$.complete();
  }
  componentWillUnmount() {
    var _this$customBrandingS;
    (_this$customBrandingS = this.customBrandingSubscription) === null || _this$customBrandingS === void 0 ? void 0 : _this$customBrandingS.unsubscribe();
  }
  render() {
    var _this$state$customBra;
    const loginState = this.state.loginState;
    if (!loginState) {
      return null;
    }
    const isSecureConnection = !!window.location.protocol.match(/^https/);
    const isCookiesEnabled = window.navigator.cookieEnabled;
    const {
      allowLogin,
      layout,
      requiresSecureConnection
    } = loginState;
    const loginIsSupported = requiresSecureConnection && !isSecureConnection || !isCookiesEnabled ? false : allowLogin && layout === 'form';
    const loginWelcomeStyle = euiTheme => (0, _react.css)`
        position: relative;
        margin: auto;
        max-width: 460px;
        padding-left: ${euiTheme.size.xl};
        padding-right: ${euiTheme.size.xl};
        z-index: 10;
        text-align: center;
      `;
    const contentHeaderStyles = euiTheme => [loginWelcomeStyle(euiTheme), !loginIsSupported && (0, _react.css)`
          max-width: 700px;
        `];
    const customLogo = (_this$state$customBra = this.state.customBranding) === null || _this$state$customBra === void 0 ? void 0 : _this$state$customBra.logo;
    const logo = customLogo ? /*#__PURE__*/_react2.default.createElement(_eui.EuiImage, {
      src: customLogo,
      size: 40,
      alt: "logo",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 161,
        columnNumber: 7
      }
    }) : /*#__PURE__*/_react2.default.createElement(_eui.EuiIcon, {
      type: "logoElastic",
      size: "xxl",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 163,
        columnNumber: 7
      }
    });
    // custom logo needs to be centered
    const logoStyle = customLogo ? {
      padding: 0
    } : {};
    return /*#__PURE__*/_react2.default.createElement("div", {
      "data-test-subj": "loginForm",
      css: _full_screen_bg_css.kbnFullScreenBgCss,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 168,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react2.default.createElement("header", {
      css: ({
        euiTheme
      }) => (0, _react.css)`
            margin-top: calc(${euiTheme.size.xxl} * 3);
            position: relative;
            padding: ${euiTheme.size.base};
            z-index: 10;
          `,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 169,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react2.default.createElement("div", {
      css: ({
        euiTheme
      }) => contentHeaderStyles(euiTheme),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 177,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react2.default.createElement("span", {
      className: "loginWelcome__logo",
      style: logoStyle,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 178,
        columnNumber: 13
      }
    }, logo), /*#__PURE__*/_react2.default.createElement(_eui.EuiTitle, {
      size: "m",
      className: "loginWelcome__title",
      "data-test-subj": "loginWelcomeTitle",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 181,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react2.default.createElement("h1", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 182,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.loginPage.welcomeTitle",
      defaultMessage: "Welcome to Elastic",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 183,
        columnNumber: 17
      }
    }))))), /*#__PURE__*/_react2.default.createElement("div", {
      css: ({
        euiTheme
      }) => contentHeaderStyles(euiTheme),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 191,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "l",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 192,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 193,
        columnNumber: 13
      }
    }, this.getLoginForm({
      ...loginState,
      isSecureConnection,
      isCookiesEnabled
    })))));
  }
}
exports.LoginPage = LoginPage;
function renderLoginPage(services, {
  element
}, props) {
  _reactDom.default.render(services.rendering.addContext(/*#__PURE__*/_react2.default.createElement(LoginPage, (0, _extends2.default)({}, props, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 390,
      columnNumber: 49
    }
  }))), element);
  return () => _reactDom.default.unmountComponentAtNode(element);
}
function isWindowEmbedded() {
  try {
    return window.self !== window.top;
  } catch (error) {
    return true;
  }
}