"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LicenseWarningNotice = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _react2 = require("@emotion/react");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/searchprofiler/public/application/components/license_warning_notice/license_warning_notice.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const styles = {
  container: (0, _react2.css)`
    max-width: 1000px;
  `,
  callOut: (0, _react2.css)`
    padding: 16px;
  `
};
const LicenseWarningNotice = () => {
  const registerLicenseLinkLabel = _i18n.i18n.translate('xpack.searchProfiler.registerLicenseLinkLabel', {
    defaultMessage: 'register a license'
  });
  const trialLicense = _i18n.i18n.translate('xpack.searchProfiler.trialLicenseTitle', {
    defaultMessage: 'Trial'
  });
  const basicLicense = _i18n.i18n.translate('xpack.searchProfiler.basicLicenseTitle', {
    defaultMessage: 'Basic'
  });
  const goldLicense = _i18n.i18n.translate('xpack.searchProfiler.goldLicenseTitle', {
    defaultMessage: 'Gold'
  });
  const platinumLicense = _i18n.i18n.translate('xpack.searchProfiler.platinumLicenseTitle', {
    defaultMessage: 'Platinum'
  });
  return /*#__PURE__*/_react.default.createElement("div", {
    css: styles.container,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 45,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: _i18n.i18n.translate('xpack.searchProfiler.licenseErrorMessageTitle', {
      defaultMessage: 'License error'
    }),
    color: "danger",
    iconType: "warning",
    css: styles.callOut,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 46,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.searchProfiler.licenseErrorMessageDescription",
    defaultMessage: "The Profiler Visualization requires an active license ({licenseTypeList} or {platinumLicenseType}), but none were found in your cluster.",
    values: {
      licenseTypeList: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 62,
          columnNumber: 21
        }
      }, trialLicense), ", ", /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 62,
          columnNumber: 56
        }
      }, basicLicense), ",", ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 63,
          columnNumber: 21
        }
      }, goldLicense)),
      platinumLicenseType: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 66,
          columnNumber: 38
        }
      }, platinumLicense)
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.searchProfiler.registerLicenseDescription",
    defaultMessage: "Please {registerLicenseLink} to continue using the Search Profiler",
    values: {
      registerLicenseLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: "https://www.elastic.co/subscriptions",
        rel: "noopener",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 76,
          columnNumber: 19
        }
      }, registerLicenseLinkLabel)
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 13
    }
  })))));
};
exports.LicenseWarningNotice = LicenseWarningNotice;