"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SynonymsSetRuleTable = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _pagination = require("../../../common/pagination");
var _use_fetch_synonyms_set = require("../../hooks/use_fetch_synonyms_set");
var _synonyms_utils = require("../../utils/synonyms_utils");
var _delete_synonym_rule_modal = require("./delete_synonym_rule_modal");
var _empty_rules_table = require("./empty_rules_table");
var _empty_rules_cards = require("./empty_rules_cards");
var _use_fetch_synonym_rule = require("../../hooks/use_fetch_synonym_rule");
var _use_fetch_generated_rule_id = require("../../hooks/use_fetch_generated_rule_id");
var _synonym_rule_flyout = require("../synonyms_rule_flyout/synonym_rule_flyout");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/search/plugins/search_synonyms/public/components/synonyms_set_detail/synonyms_set_rule_table.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const SynonymsSetRuleTable = ({
  synonymsSetId = ''
}) => {
  const [pageIndex, setPageIndex] = (0, _react.useState)(0);
  const [pageSize, setPageSize] = (0, _react.useState)(_pagination.DEFAULT_PAGE_VALUE.size);
  const {
    from
  } = (0, _pagination.paginationToPage)({
    pageIndex,
    pageSize,
    totalItemCount: 0
  });
  const [synonymRuleToDelete, setSynonymRuleToDelete] = (0, _react.useState)(null);
  const {
    data,
    isLoading,
    isInitialLoading
  } = (0, _use_fetch_synonyms_set.useFetchSynonymsSet)(synonymsSetId, {
    from,
    size: pageSize
  });
  const [addNewRulePopoverOpen, setAddNewRulePopoverOpen] = (0, _react.useState)(false);
  const [isRuleFlyoutOpen, setIsRuleFlyoutOpen] = (0, _react.useState)(true);
  const [synonymsRuleToEdit, setSynonymsRuleToEdit] = (0, _react.useState)(null);
  const [generatedId, setGeneratedId] = (0, _react.useState)(null);
  const {
    data: synonymsRule
  } = (0, _use_fetch_synonym_rule.useFetchSynonymRule)(synonymsSetId, synonymsRuleToEdit || '');
  const [ruleTypeToCreate, setRuleTypeToCreate] = (0, _react.useState)(null);
  const {
    mutate: generateRuleId
  } = (0, _use_fetch_generated_rule_id.useFetchGeneratedRuleId)(ruleId => {
    if (synonymsSetId && ruleTypeToCreate) {
      setGeneratedId(ruleId);
      setIsRuleFlyoutOpen(true);
      setAddNewRulePopoverOpen(false);
    }
  });
  if (!data) return null;
  const pagination = {
    initialPageSize: 25,
    pageSizeOptions: [10, 25, 50],
    ...data._meta,
    pageSize,
    pageIndex
  };
  const columns = [{
    field: 'synonyms',
    name: _i18n.i18n.translate('xpack.searchSynonyms.synonymsSetTable.synonymsColumn', {
      defaultMessage: 'Synonyms'
    }),
    render: (synonyms, synonymRule) => {
      const isExplicit = (0, _synonyms_utils.isExplicitSynonym)(synonyms);
      const {
        mapFromString: explicitFrom = '',
        mapToString: explicitTo = ''
      } = isExplicit ? (0, _synonyms_utils.getExplicitSynonym)(synonyms) : {};
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        responsive: false,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 82,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 83,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
        "data-test-subj": "searchSynonymsColumnsButton",
        iconType: "expand",
        "aria-label": _i18n.i18n.translate('xpack.searchSynonyms.synonymsSetTable.expandSynonyms.aria.label', {
          defaultMessage: 'Expand synonyms rule'
        }),
        onClick: () => {
          if (synonymRule.id) {
            setSynonymsRuleToEdit(synonymRule.id);
            setIsRuleFlyoutOpen(true);
          }
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 84,
          columnNumber: 15
        }
      })), isExplicit ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        "data-test-subj": "synonyms-set-item-explicit-from",
        grow: 7,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 103,
          columnNumber: 17
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 104,
          columnNumber: 19
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextTruncate, {
        text: explicitFrom,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 105,
          columnNumber: 21
        }
      }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 108,
          columnNumber: 17
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 109,
          columnNumber: 19
        }
      }, /*#__PURE__*/_react.default.createElement("b", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 110,
          columnNumber: 21
        }
      }, '=>'))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: 1,
        "data-test-subj": "synonyms-set-item-explicit-to",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 113,
          columnNumber: 17
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 114,
          columnNumber: 19
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextTruncate, {
        text: explicitTo,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 115,
          columnNumber: 21
        }
      })))) : /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        "data-test-subj": "synonyms-set-item-equivalent",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 120,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 121,
          columnNumber: 17
        }
      }, synonyms)));
    }
  }, {
    width: '8%',
    actions: [{
      name: _i18n.i18n.translate('xpack.searchSynonyms.synonymsSetTable.actions.delete', {
        defaultMessage: 'Delete'
      }),
      description: _i18n.i18n.translate('xpack.searchSynonyms.synonymsSetTable.actions.deleteDescription', {
        defaultMessage: 'Delete synonym rule'
      }),
      icon: 'trash',
      color: 'danger',
      type: 'icon',
      'data-test-subj': 'searchSynonymsSynonymsSetTableDeleteRuleButton',
      onClick: synonymRule => {
        if (synonymRule.id) {
          setSynonymRuleToDelete(synonymRule.id);
        }
      }
    }, {
      name: _i18n.i18n.translate('xpack.searchSynonyms.synonymsSetTable.actions.edit', {
        defaultMessage: 'Edit'
      }),
      description: _i18n.i18n.translate('xpack.searchSynonyms.synonymsSetTable.actions.editDescription', {
        defaultMessage: 'Edit synonym rule'
      }),
      icon: 'pencil',
      type: 'icon',
      'data-test-subj': 'searchSynonymsSynonymsSetTableEditRuleButton',
      onClick: synonymRule => {
        if (synonymRule.id) {
          setSynonymsRuleToEdit(synonymRule.id);
          setIsRuleFlyoutOpen(true);
        }
      }
    }]
  }];
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, synonymRuleToDelete && /*#__PURE__*/_react.default.createElement(_delete_synonym_rule_modal.DeleteSynonymRuleModal, {
    synonymsSetId: synonymsSetId,
    ruleId: synonymRuleToDelete,
    closeDeleteModal: () => setSynonymRuleToDelete(null),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 178,
      columnNumber: 9
    }
  }), data.data.length === 0 && !isInitialLoading && /*#__PURE__*/_react.default.createElement(_empty_rules_table.SynonymsSetEmptyRuleTable, {
    onCreateRule: type => {
      setRuleTypeToCreate(type);
      generateRuleId({
        synonymsSetId
      });
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 185,
      columnNumber: 9
    }
  }), isRuleFlyoutOpen && generatedId ? /*#__PURE__*/_react.default.createElement(_synonym_rule_flyout.SynonymRuleFlyout, {
    synonymsSetId: synonymsSetId,
    onClose: () => {
      setIsRuleFlyoutOpen(false);
      setSynonymsRuleToEdit(null);
      setGeneratedId(null);
      setRuleTypeToCreate(null);
    },
    flyoutMode: 'create',
    synonymsRule: {
      id: generatedId,
      synonyms: ''
    },
    renderExplicit: ruleTypeToCreate === 'explicit',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 194,
      columnNumber: 9
    }
  }) : synonymsRule && /*#__PURE__*/_react.default.createElement(_synonym_rule_flyout.SynonymRuleFlyout, {
    synonymsSetId: synonymsSetId,
    onClose: () => {
      setIsRuleFlyoutOpen(false);
      setSynonymsRuleToEdit(null);
      setGeneratedId(null);
      setRuleTypeToCreate(null);
    },
    flyoutMode: 'edit',
    synonymsRule: synonymsRule,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 208,
      columnNumber: 11
    }
  }), data.data.length !== 0 && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      "data-test-subj": "searchSynonymsSynonymsSetRuleTableAddRuleButton",
      iconType: "plusInCircle",
      onClick: () => {
        setAddNewRulePopoverOpen(true);
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 225,
        columnNumber: 15
      }
    }, _i18n.i18n.translate('xpack.searchSynonyms.synonymsSetTable.addRuleButton', {
      defaultMessage: 'Add rule'
    })),
    isOpen: addNewRulePopoverOpen,
    closePopover: () => setAddNewRulePopoverOpen(false),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 223,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 240,
      columnNumber: 13
    }
  }, _i18n.i18n.translate('xpack.searchSynonyms.synonymsSetTable.addRule.title', {
    defaultMessage: 'Select a rule type'
  })), /*#__PURE__*/_react.default.createElement(_empty_rules_cards.SynonymsSetEmptyRulesCards, {
    onCreateRule: type => {
      setRuleTypeToCreate(type);
      generateRuleId({
        synonymsSetId
      });
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 245,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    "data-test-subj": "synonyms-set-table",
    items: data.data,
    columns: columns,
    loading: isLoading,
    pagination: pagination,
    onChange: ({
      page
    }) => {
      setPageIndex(page.index);
      setPageSize(page.size);
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 253,
      columnNumber: 11
    }
  })));
};
exports.SynonymsSetRuleTable = SynonymsSetRuleTable;