"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PlaygroundMoreOptionsMenu = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _reactHookForm = require("react-hook-form");
var _saved_playgrounds = require("../../utils/saved_playgrounds");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/search/plugins/search_playground/public/components/saved_playground/playground_more_options.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * Props for the PlaygroundMoreOptionsMenu component
 */

const PlaygroundMoreOptionsMenu = ({
  onSavePlaygroundAs,
  onDeletePlayground
}) => {
  const [showMoreOptions, setShowMoreOptions] = (0, _react.useState)(false);
  const {
    formState: {
      errors: formErrors
    }
  } = (0, _reactHookForm.useFormContext)();
  const hasFormErrors = (0, _saved_playgrounds.hasSavedPlaygroundFormErrors)(formErrors);
  const closePopover = (0, _react.useCallback)(() => setShowMoreOptions(false), []);
  const onOpenDeleteConfirm = (0, _react.useCallback)(() => {
    closePopover();
    onDeletePlayground();
  }, [onDeletePlayground, closePopover]);
  const onOpenSaveAs = (0, _react.useCallback)(() => {
    closePopover();
    onSavePlaygroundAs();
  }, [onSavePlaygroundAs, closePopover]);
  const togglePopover = (0, _react.useCallback)(() => {
    setShowMoreOptions(!showMoreOptions);
  }, [showMoreOptions]);
  const menuItems = [/*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    key: "savePlaygroundAs",
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "save",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 59,
        columnNumber: 13
      }
    }),
    size: "s",
    onClick: onOpenSaveAs,
    "data-test-subj": "moreOptionsSavePlaygroundAs",
    disabled: hasFormErrors,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.searchPlayground.savedPlayground.moreOptions.saveAs.label",
    defaultMessage: "Save as",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 9
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    key: "deletePlayground",
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      color: "danger",
      type: "trash",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 74,
        columnNumber: 13
      }
    }),
    size: "s",
    onClick: onOpenDeleteConfirm,
    "data-test-subj": "moreOptionsDeletePlayground",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "danger",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.searchPlayground.savedPlayground.moreOptions.deletePlayground.label",
    defaultMessage: "Delete playground",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 9
    }
  })))];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    isOpen: showMoreOptions,
    closePopover: closePopover,
    panelPaddingSize: "none",
    anchorPosition: "downLeft",
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      iconType: "boxesVertical",
      onClick: togglePopover,
      size: "m",
      "data-test-subj": "moreOptionsActionButton",
      "aria-label": _i18n.i18n.translate('xpack.searchPlayground.savedPlayground.moreOptions.ariaLabel', {
        defaultMessage: 'More options'
      }),
      "aria-expanded": showMoreOptions,
      "aria-haspopup": "true",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 95,
        columnNumber: 9
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
    "data-test-subj": "moreOptionsContextMenu",
    items: menuItems,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 111,
      columnNumber: 7
    }
  }));
};
exports.PlaygroundMoreOptionsMenu = PlaygroundMoreOptionsMenu;