"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerEmbeddables = registerEmbeddables;
var _public = require("@kbn/observability-shared-plugin/public");
var _flamegraph = require("./flamegraph");
var _functions = require("./functions");
var _stack_traces = require("./stack_traces");
var _search_bar = require("./search_bar");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function registerEmbeddables(deps) {
  const {
    pluginsSetup: {
      observabilityShared
    }
  } = deps;
  observabilityShared.registerProfilingComponent(_public.EMBEDDABLE_FLAMEGRAPH, (0, _flamegraph.getEmbeddableFlamegraphComponent)(deps));
  observabilityShared.registerProfilingComponent(_public.EMBEDDABLE_FUNCTIONS, (0, _functions.getEmbeddableFunctionsComponent)(deps));
  observabilityShared.registerProfilingComponent(_public.EMBEDDABLE_PROFILING_SEARCH_BAR, (0, _search_bar.getEmbeddableSearchBarComponent)(deps));
  observabilityShared.registerProfilingComponent(_public.EMBEDDABLE_STACK_TRACES, (0, _stack_traces.getEmbeddableStackTracesComponent)(deps));
}