"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.validateArtifactArchive = void 0;
var _productDocCommon = require("@kbn/product-doc-common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const validateArtifactArchive = archive => {
  if (!archive.hasEntry('manifest.json')) {
    return {
      valid: false,
      error: 'Manifest file not found'
    };
  }
  if (!archive.hasEntry('mappings.json')) {
    return {
      valid: false,
      error: 'Mapping file not found'
    };
  }
  if (!archive.getEntryPaths().some(_productDocCommon.isArtifactContentFilePath)) {
    return {
      valid: false,
      error: 'No content files were found'
    };
  }
  return {
    valid: true
  };
};
exports.validateArtifactArchive = validateArtifactArchive;