"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EditPackPage = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _layouts = require("../../../components/layouts");
var _kibana = require("../../../common/lib/kibana");
var _form = require("../../../packs/form");
var _use_pack = require("../../../packs/use_pack");
var _use_delete_pack = require("../../../packs/use_delete_pack");
var _use_breadcrumbs = require("../../../common/hooks/use_breadcrumbs");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/osquery/public/routes/packs/edit/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const EditPackPageComponent = () => {
  var _data$id, _data$name;
  const confirmModalTitleId = (0, _eui.useGeneratedHtmlId)();
  const {
    packId
  } = (0, _reactRouterDom.useParams)();
  const queryDetailsLinkProps = (0, _kibana.useRouterNavigate)(`packs/${packId}`);
  const [isDeleteModalVisible, setIsDeleteModalVisible] = (0, _react.useState)(false);
  const {
    isLoading,
    data
  } = (0, _use_pack.usePack)({
    packId
  });
  const deletePackMutation = (0, _use_delete_pack.useDeletePack)({
    packId,
    withRedirect: true
  });
  const isReadOnly = (0, _react.useMemo)(() => !!(data !== null && data !== void 0 && data.read_only), [data]);
  (0, _use_breadcrumbs.useBreadcrumbs)('pack_edit', {
    packId: (_data$id = data === null || data === void 0 ? void 0 : data.id) !== null && _data$id !== void 0 ? _data$id : '',
    packName: (_data$name = data === null || data === void 0 ? void 0 : data.name) !== null && _data$name !== void 0 ? _data$name : ''
  });
  const handleCloseDeleteConfirmationModal = (0, _react.useCallback)(() => {
    setIsDeleteModalVisible(false);
  }, []);
  const handleDeleteClick = (0, _react.useCallback)(() => {
    setIsDeleteModalVisible(true);
  }, []);
  const handleDeleteConfirmClick = (0, _react.useCallback)(() => {
    deletePackMutation.mutateAsync().then(() => {
      handleCloseDeleteConfirmationModal();
    });
  }, [deletePackMutation, handleCloseDeleteConfirmationModal]);
  const LeftColumn = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "flexStart",
    direction: "column",
    gutterSize: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 64,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, (0, _extends2.default)({
    iconType: "arrowLeft"
  }, queryDetailsLinkProps, {
    flush: "left",
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.osquery.editPack.viewPackListTitle",
    defaultMessage: "View {queryName} details"
    // eslint-disable-next-line react-perf/jsx-no-new-object-as-prop
    ,
    values: {
      queryName: data === null || data === void 0 ? void 0 : data.name
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("h1", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.osquery.editPack.pageTitle",
    defaultMessage: "Edit {queryName}"
    // eslint-disable-next-line react-perf/jsx-no-new-object-as-prop
    ,
    values: {
      queryName: data === null || data === void 0 ? void 0 : data.name
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 15
    }
  }))))), [data === null || data === void 0 ? void 0 : data.name, queryDetailsLinkProps]);
  const RightColumn = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    color: "danger",
    onClick: handleDeleteClick,
    iconType: "trash",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.osquery.editPack.deletePackButtonLabel",
    defaultMessage: "Delete pack",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 97,
      columnNumber: 9
    }
  })), [handleDeleteClick]);
  const HeaderContent = (0, _react.useMemo)(() => isReadOnly ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 111,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.osquery.editPack.prebuiltPackModeDescription",
    defaultMessage: "This is a prebuilt Elastic pack. You can modify the scheduled agent policies, but you cannot edit queries in the pack.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 112,
      columnNumber: 13
    }
  }))) : null, [isReadOnly]);
  const titleProps = (0, _react.useMemo)(() => ({
    id: confirmModalTitleId
  }), [confirmModalTitleId]);
  if (isLoading) return null;
  return /*#__PURE__*/_react.default.createElement(_layouts.WithHeaderLayout, {
    leftColumn: LeftColumn,
    rightColumn: RightColumn,
    rightColumnGrow: false,
    headerChildren: HeaderContent,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 127,
      columnNumber: 5
    }
  }, !data ? /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
    lines: 10,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 134,
      columnNumber: 9
    }
  }) : /*#__PURE__*/_react.default.createElement(_form.PackForm, {
    editMode: true,
    defaultValue: data,
    isReadOnly: isReadOnly,
    packId: packId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 136,
      columnNumber: 9
    }
  }), isDeleteModalVisible ? /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    "aria-labelledby": confirmModalTitleId,
    titleProps: titleProps,
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.osquery.deletePack.confirmationModal.title",
      defaultMessage: "Are you sure you want to delete this pack?",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 143,
        columnNumber: 13
      }
    }),
    onCancel: handleCloseDeleteConfirmationModal,
    onConfirm: handleDeleteConfirmClick,
    confirmButtonDisabled: deletePackMutation.isLoading,
    cancelButtonText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.osquery.deletePack.confirmationModal.cancelButtonLabel",
      defaultMessage: "Cancel",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 152,
        columnNumber: 13
      }
    }),
    confirmButtonText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.osquery.deletePack.confirmationModal.confirmButtonLabel",
      defaultMessage: "Confirm",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 158,
        columnNumber: 13
      }
    }),
    buttonColor: "danger",
    defaultFocusedButton: "confirm",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 139,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.osquery.deletePack.confirmationModal.body",
    defaultMessage: "You're about to delete this pack. Are you sure you want to do this?",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 166,
      columnNumber: 11
    }
  })) : null);
};
const EditPackPage = exports.EditPackPage = /*#__PURE__*/_react.default.memo(EditPackPageComponent);