"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.PackQueriesTable = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _platforms = require("./queries/platforms");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/osquery/public/packs/pack_queries_table.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const PackQueriesTableComponent = ({
  data,
  isReadOnly,
  onDeleteClick,
  onEditClick,
  selectedItems,
  setSelectedItems
}) => {
  const renderDeleteAction = (0, _react.useCallback)(item => /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    color: "danger"
    // eslint-disable-next-line react/jsx-no-bind, react-perf/jsx-no-new-function-as-prop
    ,
    onClick: () => onDeleteClick && onDeleteClick(item),
    iconType: "trash",
    "aria-label": _i18n.i18n.translate('xpack.osquery.pack.queriesTable.deleteActionAriaLabel', {
      defaultMessage: 'Delete {queryName}',
      values: {
        queryName: item.id
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 34,
      columnNumber: 7
    }
  }), [onDeleteClick]);
  const renderEditAction = (0, _react.useCallback)(item => /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    color: "primary"
    // eslint-disable-next-line react/jsx-no-bind, react-perf/jsx-no-new-function-as-prop
    ,
    onClick: () => onEditClick && onEditClick(item),
    iconType: "pencil",
    "aria-label": _i18n.i18n.translate('xpack.osquery.pack.queriesTable.editActionAriaLabel', {
      defaultMessage: 'Edit {queryName}',
      values: {
        queryName: item.id
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 52,
      columnNumber: 7
    }
  }), [onEditClick]);
  const renderQueryColumn = (0, _react.useCallback)(query => /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    language: "sql",
    fontSize: "s",
    paddingSize: "none",
    transparentBackground: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 7
    }
  }, query), []);
  const renderPlatformColumn = (0, _react.useCallback)(platform => /*#__PURE__*/_react.default.createElement(_platforms.PlatformIcons, {
    platform: platform,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 27
    }
  }), []);
  const renderVersionColumn = (0, _react.useCallback)(version => version ? `${version}` : _i18n.i18n.translate('xpack.osquery.pack.queriesTable.osqueryVersionAllLabel', {
    defaultMessage: 'ALL'
  }), []);
  const columns = (0, _react.useMemo)(() => [{
    field: 'id',
    name: _i18n.i18n.translate('xpack.osquery.pack.queriesTable.idColumnTitle', {
      defaultMessage: 'ID'
    }),
    width: '20%'
  }, {
    field: 'interval',
    name: _i18n.i18n.translate('xpack.osquery.pack.queriesTable.intervalColumnTitle', {
      defaultMessage: 'Interval (s)'
    }),
    width: '100px'
  }, {
    field: 'query',
    name: _i18n.i18n.translate('xpack.osquery.pack.queriesTable.queryColumnTitle', {
      defaultMessage: 'Query'
    }),
    render: renderQueryColumn
  }, {
    field: 'platform',
    name: _i18n.i18n.translate('xpack.osquery.pack.queriesTable.platformColumnTitle', {
      defaultMessage: 'Platform'
    }),
    render: renderPlatformColumn
  }, {
    field: 'version',
    name: _i18n.i18n.translate('xpack.osquery.pack.queriesTable.versionColumnTitle', {
      defaultMessage: 'Min Osquery version'
    }),
    render: renderVersionColumn
  }, ...(!isReadOnly ? [{
    name: _i18n.i18n.translate('xpack.osquery.pack.queriesTable.actionsColumnTitle', {
      defaultMessage: 'Actions'
    }),
    width: '120px',
    actions: [{
      render: renderEditAction
    }, {
      render: renderDeleteAction
    }]
  }] : [])], [isReadOnly, renderDeleteAction, renderEditAction, renderPlatformColumn, renderQueryColumn, renderVersionColumn]);
  const sorting = (0, _react.useMemo)(() => ({
    sort: {
      field: 'id',
      direction: 'asc'
    }
  }), []);
  const itemId = (0, _react.useCallback)(item => {
    var _item$id;
    return (_item$id = item.id) !== null && _item$id !== void 0 ? _item$id : '';
  }, []);
  const selection = (0, _react.useMemo)(() => ({
    onSelectionChange: setSelectedItems,
    initialSelected: selectedItems
  }), [selectedItems, setSelectedItems]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    items: data,
    itemId: itemId,
    columns: columns,
    sorting: sorting,
    selection: isReadOnly ? undefined : selection,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 179,
      columnNumber: 5
    }
  });
};
const PackQueriesTable = exports.PackQueriesTable = /*#__PURE__*/_react.default.memo(PackQueriesTableComponent);
// eslint-disable-next-line import/no-default-export
var _default = exports.default = PackQueriesTable;