"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LiveQuery = void 0;
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _replace_params_query = require("../../common/utils/replace_params_query");
var _contexts = require("../common/contexts");
var _form = require("./form");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/osquery/public/live_queries/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const LiveQueryComponent = ({
  agentId,
  agentIds,
  alertIds,
  agentPolicyIds,
  onSuccess,
  query,
  savedQueryId,
  // eslint-disable-next-line @typescript-eslint/naming-convention
  ecs_mapping,
  queryField,
  ecsMappingField,
  formType,
  enabled,
  hideAgentsField,
  packId,
  agentSelection,
  timeout
}) => {
  const initialAgentSelection = (0, _react.useMemo)(() => {
    if (agentSelection) {
      return agentSelection;
    }
    if (agentId || agentPolicyIds !== null && agentPolicyIds !== void 0 && agentPolicyIds.length) {
      var _ref;
      return {
        allAgentsSelected: false,
        agents: (0, _lodash.castArray)((_ref = agentId !== null && agentId !== void 0 ? agentId : agentIds) !== null && _ref !== void 0 ? _ref : []),
        platformsSelected: [],
        policiesSelected: agentPolicyIds !== null && agentPolicyIds !== void 0 ? agentPolicyIds : []
      };
    }
    return null;
  }, [agentId, agentIds, agentPolicyIds, agentSelection]);
  const ecsData = (0, _react.useContext)(_contexts.AlertAttachmentContext);
  const initialQuery = (0, _react.useMemo)(() => {
    if (ecsData && query) {
      const {
        result
      } = (0, _replace_params_query.replaceParamsQuery)(query, ecsData);
      return result;
    }
    return query;
  }, [ecsData, query]);
  const defaultValue = (0, _react.useMemo)(() => {
    const initialValue = {
      ...(initialAgentSelection ? {
        agentSelection: initialAgentSelection
      } : {}),
      alertIds,
      query: initialQuery,
      savedQueryId,
      ecs_mapping,
      timeout,
      packId
    };
    return !(0, _lodash.isEmpty)((0, _lodash.pickBy)(initialValue, value => !(0, _lodash.isEmpty)(value))) ? initialValue : undefined;
  }, [alertIds, ecs_mapping, initialAgentSelection, initialQuery, packId, savedQueryId, timeout]);
  return /*#__PURE__*/_react.default.createElement(_form.LiveQueryForm, {
    queryField: queryField,
    ecsMappingField: ecsMappingField,
    defaultValue: defaultValue,
    onSuccess: onSuccess,
    formType: formType,
    enabled: enabled,
    hideAgentsField: hideAgentsField,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 99,
      columnNumber: 5
    }
  });
};
const LiveQuery = exports.LiveQuery = /*#__PURE__*/_react.default.memo(LiveQueryComponent);