"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ActionsTable = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _lodash = require("lodash");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _constants = require("../../common/constants");
var _remove_multilines = require("../../common/utils/build_query/remove_multilines");
var _use_all_live_queries = require("./use_all_live_queries");
var _kibana = require("../common/lib/kibana");
var _use_packs = require("../packs/use_packs");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/osquery/public/actions/actions_table.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const EMPTY_ARRAY = [];
const ActionTableResultsButton = ({
  actionId
}) => {
  const navProps = (0, _kibana.useRouterNavigate)(`live_queries/${actionId}`);
  const detailsText = _i18n.i18n.translate('xpack.osquery.liveQueryActions.table.viewDetailsActionButton', {
    defaultMessage: 'Details'
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "top",
    content: detailsText,
    disableScreenReaderOutput: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 47,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, (0, _extends2.default)({
    iconType: "visTable"
  }, navProps, {
    "aria-label": detailsText,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 7
    }
  })));
};
ActionTableResultsButton.displayName = 'ActionTableResultsButton';
const ActionsTableComponent = () => {
  var _actionsData$data$ite, _actionsData$data2;
  const permissions = (0, _kibana.useKibana)().services.application.capabilities.osquery;
  const {
    push
  } = (0, _reactRouterDom.useHistory)();
  const [pageIndex, setPageIndex] = (0, _react.useState)(0);
  const [pageSize, setPageSize] = (0, _react.useState)(20);
  const {
    data: packsData
  } = (0, _use_packs.usePacks)({});
  const {
    data: actionsData
  } = (0, _use_all_live_queries.useAllLiveQueries)({
    activePage: pageIndex,
    limit: pageSize,
    kuery: 'user_id: *'
  });
  const onTableChange = (0, _react.useCallback)(({
    page = {}
  }) => {
    const {
      index,
      size
    } = page;
    setPageIndex(index);
    setPageSize(size);
  }, []);
  const renderQueryColumn = (0, _react.useCallback)((_, item) => {
    if (item._source.pack_name) {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        gutterSize: "s",
        alignItems: "center",
        justifyContent: "center",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 79,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 80,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        type: "package",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 81,
          columnNumber: 13
        }
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 83,
          columnNumber: 11
        }
      }, item._source.pack_name));
    }
    const query = item._source.queries[0].query;
    const singleLine = (0, _remove_multilines.removeMultilines)(query);
    const content = singleLine.length > 90 ? `${singleLine === null || singleLine === void 0 ? void 0 : singleLine.substring(0, 90)}...` : singleLine;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
      language: "sql",
      fontSize: "s",
      paddingSize: "none",
      transparentBackground: true,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 93,
        columnNumber: 7
      }
    }, content);
  }, []);
  const renderAgentsColumn = (0, _react.useCallback)((_, item) => {
    var _item$fields$agents$l, _item$fields$agents;
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, (_item$fields$agents$l = (_item$fields$agents = item.fields.agents) === null || _item$fields$agents === void 0 ? void 0 : _item$fields$agents.length) !== null && _item$fields$agents$l !== void 0 ? _item$fields$agents$l : 0);
  }, []);
  const renderCreatedByColumn = (0, _react.useCallback)(userId => (0, _lodash.isArray)(userId) ? userId[0] : '-', []);
  const renderTimestampColumn = (0, _react.useCallback)((_, item) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, (0, _eui.formatDate)(item.fields['@timestamp'][0])), []);
  const renderActionsColumn = (0, _react.useCallback)(item => /*#__PURE__*/_react.default.createElement(ActionTableResultsButton, {
    actionId: item.fields.action_id[0],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 115,
      columnNumber: 20
    }
  }), []);
  const handlePlayClick = (0, _react.useCallback)(item => () => {
    var _item$_source$queries;
    const packId = item._source.pack_id;
    if (packId) {
      return push('/live_queries/new', {
        form: (0, _lodash.pickBy)({
          packId: item._source.pack_id,
          agentSelection: {
            agents: item._source.agent_ids,
            allAgentsSelected: item._source.agent_all,
            platformsSelected: item._source.agent_platforms,
            policiesSelected: item._source.agent_policy_ids
          }
        }, value => !(0, _lodash.isEmpty)(value))
      });
    }
    push('/live_queries/new', {
      form: (0, _lodash.pickBy)({
        query: item._source.queries[0].query,
        ecs_mapping: item._source.queries[0].ecs_mapping,
        savedQueryId: item._source.queries[0].saved_query_id,
        timeout: (_item$_source$queries = item._source.queries[0].timeout) !== null && _item$_source$queries !== void 0 ? _item$_source$queries : _constants.QUERY_TIMEOUT.DEFAULT,
        agentSelection: {
          agents: item._source.agent_ids,
          allAgentsSelected: item._source.agent_all,
          platformsSelected: item._source.agent_platforms,
          policiesSelected: item._source.agent_policy_ids
        }
      }, value => !(0, _lodash.isEmpty)(value) || (0, _lodash.isNumber)(value))
    });
  }, [push]);
  const renderPlayButton = (0, _react.useCallback)((item, enabled) => {
    const playText = _i18n.i18n.translate('xpack.osquery.liveQueryActions.table.runActionAriaLabel', {
      defaultMessage: 'Run query'
    });
    return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      position: "top",
      content: playText,
      disableScreenReaderOutput: true,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 167,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      iconType: "play",
      onClick: handlePlayClick(item),
      isDisabled: !enabled,
      "aria-label": playText,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 168,
        columnNumber: 11
      }
    }));
  }, [handlePlayClick]);
  const existingPackIds = (0, _react.useMemo)(() => {
    var _packsData$data;
    return (0, _lodash.map)((_packsData$data = packsData === null || packsData === void 0 ? void 0 : packsData.data) !== null && _packsData$data !== void 0 ? _packsData$data : [], 'id');
  }, [packsData]);
  const isPlayButtonAvailable = (0, _react.useCallback)(item => {
    var _item$fields$pack_id;
    if ((_item$fields$pack_id = item.fields.pack_id) !== null && _item$fields$pack_id !== void 0 && _item$fields$pack_id.length) {
      return existingPackIds.includes(item.fields.pack_id[0]) && permissions.runSavedQueries && permissions.readPacks;
    }
    return !!(permissions.runSavedQueries || permissions.writeLiveQueries);
  }, [permissions, existingPackIds]);
  const columns = (0, _react.useMemo)(() => [{
    field: 'query',
    name: _i18n.i18n.translate('xpack.osquery.liveQueryActions.table.queryColumnTitle', {
      defaultMessage: 'Query'
    }),
    truncateText: true,
    width: '60%',
    render: renderQueryColumn
  }, {
    field: 'agents',
    name: _i18n.i18n.translate('xpack.osquery.liveQueryActions.table.agentsColumnTitle', {
      defaultMessage: 'Agents'
    }),
    width: '100px',
    render: renderAgentsColumn
  }, {
    field: 'created_at',
    name: _i18n.i18n.translate('xpack.osquery.liveQueryActions.table.createdAtColumnTitle', {
      defaultMessage: 'Created at'
    }),
    width: '200px',
    render: renderTimestampColumn
  }, {
    field: 'fields.user_id',
    name: _i18n.i18n.translate('xpack.osquery.liveQueryActions.table.createdByColumnTitle', {
      defaultMessage: 'Run by'
    }),
    width: '200px',
    render: renderCreatedByColumn
  }, {
    name: _i18n.i18n.translate('xpack.osquery.liveQueryActions.table.viewDetailsColumnTitle', {
      defaultMessage: 'View details'
    }),
    actions: [{
      available: isPlayButtonAvailable,
      render: renderPlayButton
    }, {
      render: renderActionsColumn
    }]
  }], [isPlayButtonAvailable, renderActionsColumn, renderAgentsColumn, renderCreatedByColumn, renderPlayButton, renderQueryColumn, renderTimestampColumn]);
  const pagination = (0, _react.useMemo)(() => {
    var _actionsData$data$tot, _actionsData$data;
    return {
      pageIndex,
      pageSize,
      totalItemCount: (_actionsData$data$tot = actionsData === null || actionsData === void 0 ? void 0 : (_actionsData$data = actionsData.data) === null || _actionsData$data === void 0 ? void 0 : _actionsData$data.total) !== null && _actionsData$data$tot !== void 0 ? _actionsData$data$tot : 0,
      pageSizeOptions: [20, 50, 100]
    };
  }, [actionsData, pageIndex, pageSize]);
  const rowProps = (0, _react.useCallback)(data => ({
    'data-test-subj': `row-${data._source.action_id}`
  }), []);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    items: (_actionsData$data$ite = actionsData === null || actionsData === void 0 ? void 0 : (_actionsData$data2 = actionsData.data) === null || _actionsData$data2 === void 0 ? void 0 : _actionsData$data2.items) !== null && _actionsData$data$ite !== void 0 ? _actionsData$data$ite : EMPTY_ARRAY
    // @ts-expect-error update types
    ,
    columns: columns,
    pagination: pagination,
    onChange: onTableChange,
    rowProps: rowProps,
    "data-test-subj": "liveQueryActionsTable",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 276,
      columnNumber: 5
    }
  });
};
const ActionsTable = exports.ActionsTable = /*#__PURE__*/_react.default.memo(ActionsTableComponent);