"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useReportConverseError = void 0;
var _use_kibana = require("./use_kibana");
var _events = require("../../../common/events");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useReportEvent = () => {
  const {
    services: {
      analytics
    }
  } = (0, _use_kibana.useKibana)();
  return {
    reportEvent: ({
      eventType,
      eventData
    }) => {
      try {
        analytics.reportEvent(eventType, eventData);
      } catch {
        // Discard analytics errors
      }
    }
  };
};
const useReportConverseError = () => {
  const {
    reportEvent
  } = useReportEvent();
  return {
    reportConverseError: (error, {
      conversationId,
      agentId,
      connectorId
    }) => {
      var _error$constructor;
      reportEvent({
        eventType: _events.eventTypes.ONECHAT_CONVERSE_ERROR,
        eventData: {
          error_type: (error === null || error === void 0 ? void 0 : (_error$constructor = error.constructor) === null || _error$constructor === void 0 ? void 0 : _error$constructor.name) || 'unknown',
          error_message: error instanceof Error ? error.message : String(error),
          error_stack: error instanceof Error ? error.stack : undefined,
          conversation_id: conversationId,
          agent_id: agentId,
          connector_id: connectorId
        }
      });
    }
  };
};
exports.useReportConverseError = useReportConverseError;