"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createIndexSearchFormValidationSchema = void 0;
var _i18n = require("@kbn/i18n");
var _tools = require("@kbn/onechat-common/tools");
var _zod = require("@kbn/zod");
var _shared_tool_validation = require("./shared_tool_validation");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const indexSearchI18nMessages = {
  pattern: {
    requiredError: _i18n.i18n.translate('xpack.onechat.tools.indexPattern.pattern.requiredError', {
      defaultMessage: 'Pattern is required.'
    }),
    noMatchesError: _i18n.i18n.translate('xpack.onechat.tools.indexPattern.pattern.noMatchesError', {
      defaultMessage: 'No matches found for this pattern.'
    }),
    apiError: _i18n.i18n.translate('xpack.onechat.tools.indexPattern.pattern.error', {
      defaultMessage: 'Error loading index patterns.'
    })
  }
};
const createIndexSearchFormValidationSchema = toolsService => _zod.z.object({
  toolId: _shared_tool_validation.sharedValidationSchemas.toolId,
  description: _shared_tool_validation.sharedValidationSchemas.description,
  labels: _shared_tool_validation.sharedValidationSchemas.labels,
  pattern: _zod.z.string().min(1, {
    message: indexSearchI18nMessages.pattern.requiredError
  }).refine(async pattern => {
    if (!pattern || !pattern.trim()) {
      return true;
    }
    try {
      const response = await toolsService.resolveSearchSources({
        pattern
      });
      return response.total > 0;
    } catch {
      return false;
    }
  }, {
    message: indexSearchI18nMessages.pattern.noMatchesError
  }),
  type: _zod.z.literal(_tools.ToolType.index_search)
});
exports.createIndexSearchFormValidationSchema = createIndexSearchFormValidationSchema;