"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.validateAgentId = exports.agentIdRegexp = exports.agentIdMaxLength = void 0;
var _namespaces = require("../base/namespaces");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// - Must start and end with letter or digit
// - Can contain letters, digits, hyphens, underscores and dots
const agentIdRegexp = exports.agentIdRegexp = /^(?:[a-z0-9](?:[a-z0-9_-]*[a-z0-9])?)(?:\.(?:[a-z0-9](?:[a-z0-9_-]*[a-z0-9])?))*$/;
const agentIdMaxLength = exports.agentIdMaxLength = 64;
const validateAgentId = ({
  agentId,
  builtIn
}) => {
  if (!agentIdRegexp.test(agentId)) {
    return `Agent ids must start and end with a letter or number, and can only contain lowercase letters, numbers, dots, hyphens and underscores`;
  }
  if (agentId.length > agentIdMaxLength) {
    return `Agent ids are limited to ${agentIdMaxLength} characters.`;
  }
  if ((0, _namespaces.hasNamespaceName)(agentId)) {
    return `Agent id cannot have the same name as a reserved namespace.`;
  }
  if (!builtIn) {
    if ((0, _namespaces.isInProtectedNamespace)(agentId)) {
      return `Agent id is using a protected namespace.`;
    }
  }
};
exports.validateAgentId = validateAgentId;