"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HeaderActions = HeaderActions;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _kibana_react = require("../../../utils/kibana_react");
var _paths = require("../../../../common/locators/paths");
var _use_bulk_untrack_alerts = require("../hooks/use_bulk_untrack_alerts");
var _alert_details_rule_form_flyout = require("./alert_details_rule_form_flyout");
var _obs_cases_context = require("./obs_cases_context");
var _add_to_case_button = require("./add_to_case_button");
var _use_discover_url = require("../hooks/use_discover_url/use_discover_url");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/observability/public/pages/alert_details/components/header_actions.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function HeaderActions({
  alert,
  alertIndex,
  alertStatus,
  onUntrackAlert,
  onUpdate,
  rule,
  refetch
}) {
  const {
    services
  } = (0, _kibana_react.useKibana)();
  const {
    cases,
    triggersActionsUi: {
      getRuleSnoozeModal: RuleSnoozeModal
    },
    http
  } = services;
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const [snoozeModalOpen, setSnoozeModalOpen] = (0, _react.useState)(false);
  const {
    mutateAsync: untrackAlerts
  } = (0, _use_bulk_untrack_alerts.useBulkUntrackAlerts)();
  const {
    discoverUrl
  } = (0, _use_discover_url.useDiscoverUrl)({
    alert,
    rule
  });
  const handleUntrackAlert = (0, _react.useCallback)(async () => {
    if (alert) {
      await untrackAlerts({
        indices: ['.internal.alerts-observability.*'],
        alertUuids: [alert.fields[_ruleDataUtils.ALERT_UUID]]
      });
      onUntrackAlert();
    }
  }, [alert, untrackAlerts, onUntrackAlert]);
  const [alertDetailsRuleFormFlyoutOpen, setAlertDetailsRuleFormFlyoutOpen] = (0, _react.useState)(false);
  const handleTogglePopover = () => setIsPopoverOpen(!isPopoverOpen);
  const handleClosePopover = () => setIsPopoverOpen(false);
  const handleOpenSnoozeModal = () => {
    setIsPopoverOpen(false);
    setSnoozeModalOpen(true);
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "s",
    justifyContent: "flexEnd",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 87,
      columnNumber: 7
    }
  }, discoverUrl && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    href: discoverUrl,
    iconType: "discoverApp",
    target: "_blank",
    "data-test-subj": "view-in-discover-button",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 90,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 15
    }
  }, _i18n.i18n.translate('xpack.observability.alertDetails.viewInDiscover', {
    defaultMessage: 'View in Discover'
  })))), cases && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 106,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_obs_cases_context.ObsCasesContext, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 107,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_add_to_case_button.AddToCaseButton, {
    alert: alert,
    alertIndex: alertIndex,
    rule: rule,
    setIsPopoverOpen: setIsPopoverOpen,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 15
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 117,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    panelPaddingSize: "none",
    isOpen: isPopoverOpen,
    closePopover: handleClosePopover,
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      display: "base",
      size: "m",
      iconType: "boxesVertical",
      "data-test-subj": "alert-details-header-actions-menu-button",
      onClick: handleTogglePopover,
      "aria-label": _i18n.i18n.translate('xpack.observability.alertDetails.actionsButtonLabel', {
        defaultMessage: 'Actions'
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 123,
        columnNumber: 15
      }
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 118,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    style: {
      width: '220px'
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 135,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    alignItems: "flexStart",
    gutterSize: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 136,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 137,
      columnNumber: 17
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    size: "s",
    color: "text",
    iconType: "bellSlash",
    onClick: handleOpenSnoozeModal,
    disabled: !(alert !== null && alert !== void 0 && alert.fields[_ruleDataUtils.ALERT_RULE_UUID]) || !rule,
    "data-test-subj": "snooze-rule-button",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 139,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 147,
      columnNumber: 19
    }
  }, _i18n.i18n.translate('xpack.observability.alertDetails.editSnoozeRule', {
    defaultMessage: 'Snooze the rule'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    size: "s",
    color: "text",
    iconType: "pencil",
    onClick: () => {
      setIsPopoverOpen(false);
      setAlertDetailsRuleFormFlyoutOpen(true);
    },
    disabled: !(alert !== null && alert !== void 0 && alert.fields[_ruleDataUtils.ALERT_RULE_UUID]) || !rule,
    "data-test-subj": "edit-rule-button",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 154,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 165,
      columnNumber: 19
    }
  }, _i18n.i18n.translate('xpack.observability.alertDetails.editRule', {
    defaultMessage: 'Edit rule'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    size: "s",
    color: "text",
    iconType: "eyeClosed",
    onClick: handleUntrackAlert,
    "data-test-subj": "untrack-alert-button",
    disabled: alertStatus !== _ruleDataUtils.ALERT_STATUS_ACTIVE,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 172,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 180,
      columnNumber: 19
    }
  }, _i18n.i18n.translate('xpack.observability.alertDetails.untrackAlert', {
    defaultMessage: 'Mark as untracked'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "none",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 187,
      columnNumber: 17
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    size: "s",
    color: "text",
    iconType: "link",
    disabled: !(alert !== null && alert !== void 0 && alert.fields[_ruleDataUtils.ALERT_RULE_UUID]) || !rule,
    "data-test-subj": "view-rule-details-button",
    href: rule ? http.basePath.prepend(_paths.paths.observability.ruleDetails(rule.id)) : '',
    target: "_blank",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 189,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 198,
      columnNumber: 19
    }
  }, _i18n.i18n.translate('xpack.observability.alertDetails.viewRuleDetails', {
    defaultMessage: 'Go to rule details'
  }))), /*#__PURE__*/_react.default.createElement("div", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 205,
      columnNumber: 17
    }
  })))))), rule && /*#__PURE__*/_react.default.createElement(_alert_details_rule_form_flyout.AlertDetailsRuleFormFlyout, {
    isRuleFormFlyoutOpen: alertDetailsRuleFormFlyoutOpen,
    setIsRuleFormFlyoutOpen: setAlertDetailsRuleFormFlyoutOpen,
    onUpdate: onUpdate,
    refetch: refetch,
    rule: rule,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 212,
      columnNumber: 9
    }
  }), rule && snoozeModalOpen ? /*#__PURE__*/_react.default.createElement(RuleSnoozeModal, {
    rule: rule,
    onClose: () => setSnoozeModalOpen(false),
    onRuleChanged: async () => {
      refetch();
    },
    onLoading: _lodash.noop,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 222,
      columnNumber: 9
    }
  }) : null);
}