"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _reactHookForm = require("react-hook-form");
var _annotation_form = require("../annotation_form");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/observability/public/components/annotations/components/create_annotation.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function CreateAnnotation({
  onSave,
  onCancel,
  isLoading,
  editAnnotation,
  createAnnotation,
  deleteAnnotation,
  updateAnnotation,
  isCreateAnnotationsOpen
}) {
  const {
    trigger,
    getValues
  } = (0, _reactHookForm.useFormContext)();
  const onSubmit = (0, _react.useCallback)(async () => {
    const isValid = await trigger();
    if (!isValid) return;
    const values = getValues();
    const timestamp = values['@timestamp'].toISOString();
    if (editAnnotation !== null && editAnnotation !== void 0 && editAnnotation.id) {
      var _values$event, _values$event$end;
      await updateAnnotation({
        annotation: {
          ...values,
          id: editAnnotation.id,
          '@timestamp': timestamp,
          event: {
            start: timestamp,
            end: (_values$event = values.event) === null || _values$event === void 0 ? void 0 : (_values$event$end = _values$event.end) === null || _values$event$end === void 0 ? void 0 : _values$event$end.toISOString()
          }
        }
      });
    } else {
      var _values$event2, _values$event2$end;
      await createAnnotation({
        annotation: {
          ...values,
          '@timestamp': timestamp,
          event: {
            start: timestamp,
            end: (_values$event2 = values.event) === null || _values$event2 === void 0 ? void 0 : (_values$event2$end = _values$event2.end) === null || _values$event2$end === void 0 ? void 0 : _values$event2$end.toISOString()
          }
        }
      });
    }
    onSave();
  }, [trigger, getValues, editAnnotation === null || editAnnotation === void 0 ? void 0 : editAnnotation.id, onSave, updateAnnotation, createAnnotation]);
  const onDelete = async () => {
    if (editAnnotation !== null && editAnnotation !== void 0 && editAnnotation.id) {
      await deleteAnnotation({
        annotations: [editAnnotation]
      });
      onSave();
    }
  };
  const flyoutTitleId = (0, _eui.useGeneratedHtmlId)();
  let flyout;
  if (isCreateAnnotationsOpen) {
    flyout = /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutResizable, {
      onClose: onCancel,
      type: "push",
      size: "s",
      maxWidth: 700,
      "aria-labelledby": flyoutTitleId,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 102,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
      hasBorder: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 109,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 110,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement("h2", {
      id: flyoutTitleId,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 111,
        columnNumber: 13
      }
    }, editAnnotation ? _i18n.i18n.translate('xpack.observability.createAnnotation.editAnnotationModalHeaderTitleLabel', {
      defaultMessage: 'Update annotation'
    }) : _i18n.i18n.translate('xpack.observability.createAnnotation.addAnnotationModalHeaderTitleLabel', {
      defaultMessage: 'Create annotation'
    })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 126,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_annotation_form.AnnotationForm, {
      editAnnotation: editAnnotation,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 127,
        columnNumber: 11
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 129,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "flexStart",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 130,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 131,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      "data-test-subj": "observabilitySolutionCancelButton",
      onClick: onCancel,
      isLoading: isLoading,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 132,
        columnNumber: 15
      }
    }, _i18n.i18n.translate('xpack.observability.createAnnotation.closeButtonEmptyLabel', {
      defaultMessage: 'Close'
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 142,
        columnNumber: 13
      }
    }), (editAnnotation === null || editAnnotation === void 0 ? void 0 : editAnnotation.id) && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 144,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      "data-test-subj": "annotationDeleteButton",
      type: "submit",
      onClick: () => onDelete(),
      isLoading: isLoading,
      color: "danger",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 145,
        columnNumber: 17
      }
    }, _i18n.i18n.translate('xpack.observability.createAnnotation.deleteButtonLabel', {
      defaultMessage: 'Delete'
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 158,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      "data-test-subj": "annotationSaveButton",
      type: "submit",
      onClick: () => onSubmit(),
      isLoading: isLoading,
      fill: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 159,
        columnNumber: 15
      }
    }, editAnnotation !== null && editAnnotation !== void 0 && editAnnotation.id ? _i18n.i18n.translate('xpack.observability.createAnnotation.updateButtonLabel', {
      defaultMessage: 'Update'
    }) : _i18n.i18n.translate('xpack.observability.createAnnotation.saveButtonLabel', {
      defaultMessage: 'Save'
    }))))));
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, flyout);
}

// eslint-disable-next-line import/no-default-export
var _default = exports.default = CreateAnnotation;
module.exports = exports.default;