"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AlertSeverityBadge = AlertSeverityBadge;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/observability/public/components/alert_severity_badge.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const colorMap = {
  critical: 'danger',
  warning: 'warning'
};
function AlertSeverityBadge({
  severityLevel
}) {
  if (!severityLevel) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: severityLevel ? colorMap[severityLevel] : 'default',
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 26,
      columnNumber: 5
    }
  }, severityLevel);
}