"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ElapsedTimestampTooltip = ElapsedTimestampTooltip;
exports.getElapsedTimeText = getElapsedTimeText;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _moment = _interopRequireDefault(require("moment"));
var _datetime = require("../utils/formatters/datetime");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/observability/common/components/elapsed_timestamp_tooltip.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const RELATIVE_DISPLAY_THRESHOLD_HOURS = 2;
function getElapsedTimeText(duration) {
  const minutes = Math.floor(duration.asMinutes());
  if (minutes > 0) {
    return _i18n.i18n.translate('xpack.observability.alertsTable.highFidelityDuration', {
      defaultMessage: '{minutes, plural, one {# minute} other {# minutes}} ago',
      values: {
        minutes
      }
    });
  }
  return _i18n.i18n.translate('xpack.observability.alertsTable.highFidelityDurationRecently', {
    defaultMessage: 'a few seconds ago'
  });
}
function ElapsedTimestampTooltip({
  time
}) {
  const duration = _moment.default.duration(new Date().getTime() - time);
  const absoluteTimeLabel = (0, _datetime.asAbsoluteDateTime)(time, 'milliseconds');
  const timeDisplay = duration.asHours() > RELATIVE_DISPLAY_THRESHOLD_HOURS ? absoluteTimeLabel : getElapsedTimeText(duration);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: absoluteTimeLabel,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement("span", {
    tabIndex: 0,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 49,
      columnNumber: 7
    }
  }, timeDisplay));
}