"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.shouldIncludePointByScore = shouldIncludePointByScore;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Determines if a point should be included based on its score and selected severity thresholds
 * @param score - The anomaly score
 * @param selectedSeverity - Array of selected severity thresholds
 * @returns True if the point should be included in the results
 */
function shouldIncludePointByScore(score, selectedSeverity) {
  // Always include points with score 0, or if no severity thresholds are selected
  if (score === 0 || selectedSeverity.length === 0) {
    return true;
  }

  // Filter based on selected severity thresholds
  // This handles non-contiguous ranges like [0-3, 75+] where API filtering by min
  // would return all scores, but we only want specific ranges
  return selectedSeverity.some(threshold => {
    const minScore = threshold.min;
    const maxScore = threshold.max;
    if (maxScore !== undefined) {
      return score >= minScore && score <= maxScore;
    } else {
      return score >= minScore;
    }
  });
}