"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.dataDriftRouteIndexPatternFactory = exports.dataDriftRouteIndexOrSearchFactory = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _index_patterns_picker = require("../../../datavisualizer/data_drift/index_patterns_picker");
var _router = require("../../router");
var _locator = require("../../../../../common/constants/locator");
var _breadcrumbs = require("../../breadcrumbs");
var _use_resolver = require("../../use_resolver");
var _resolvers = require("../../resolvers");
var _ml = require("../../../contexts/ml");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/routing/routes/datavisualizer/data_drift.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const dataDriftRouteIndexOrSearchFactory = (navigateToPath, basePath) => ({
  id: 'data_drift',
  path: (0, _router.createPath)(_locator.ML_PAGES.DATA_DRIFT_INDEX_SELECT),
  title: _i18n.i18n.translate('xpack.ml.dataVisualizer.dataDrift.docTitle', {
    defaultMessage: 'Data Drift'
  }),
  render: (props, deps) => /*#__PURE__*/_react.default.createElement(PageWrapper, (0, _extends2.default)({}, props, {
    deps: deps,
    mode: _locator.ML_PAGES.DATA_DRIFT_INDEX_SELECT,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 41,
      columnNumber: 5
    }
  })),
  breadcrumbs: [(0, _breadcrumbs.getBreadcrumbWithUrlForApp)('ML_BREADCRUMB', navigateToPath, basePath), (0, _breadcrumbs.getBreadcrumbWithUrlForApp)('DATA_VISUALIZER_BREADCRUMB', navigateToPath, basePath), {
    text: _breadcrumbs.DATA_DRIFT_BREADCRUMB.text,
    ...(navigateToPath ? {
      href: `${basePath}/app/ml${_breadcrumbs.DATA_DRIFT_BREADCRUMB.href}`,
      onClick: (0, _breadcrumbs.breadcrumbOnClickFactory)(_breadcrumbs.DATA_DRIFT_BREADCRUMB.href, navigateToPath)
    } : {})
  }, {
    text: _i18n.i18n.translate('xpack.ml.trainedModelsBreadcrumbs.dataDriftLabel', {
      defaultMessage: 'Select Data View'
    })
  }],
  'data-test-subj': 'mlPageDataDrift'
});
exports.dataDriftRouteIndexOrSearchFactory = dataDriftRouteIndexOrSearchFactory;
const dataDriftRouteIndexPatternFactory = (navigateToPath, basePath) => ({
  id: 'data_drift',
  path: (0, _router.createPath)(_locator.ML_PAGES.DATA_DRIFT_CUSTOM),
  title: _i18n.i18n.translate('xpack.ml.dataVisualizer.dataDriftCustomIndexPatterns.docTitle', {
    defaultMessage: 'Data Drift Custom Index Patterns'
  }),
  render: (props, deps) => /*#__PURE__*/_react.default.createElement(PageWrapper, (0, _extends2.default)({}, props, {
    deps: deps,
    mode: _locator.ML_PAGES.DATA_DRIFT_CUSTOM,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 28
    }
  })),
  breadcrumbs: [(0, _breadcrumbs.getBreadcrumbWithUrlForApp)('ML_BREADCRUMB', navigateToPath, basePath), {
    text: _breadcrumbs.DATA_VISUALIZER_BREADCRUMB.text,
    ...(navigateToPath ? {
      href: `${basePath}/app/ml${_breadcrumbs.DATA_DRIFT_INDEX_SELECT_BREADCRUMB.href}`,
      onClick: (0, _breadcrumbs.breadcrumbOnClickFactory)(_breadcrumbs.DATA_DRIFT_INDEX_SELECT_BREADCRUMB.href, navigateToPath)
    } : {})
  }, {
    text: _i18n.i18n.translate('xpack.ml.trainedModelsBreadcrumbs.dataDriftLabel', {
      defaultMessage: 'Data Drift'
    })
  }],
  'data-test-subj': 'mlPageDataDriftCustomIndexPatterns'
});
exports.dataDriftRouteIndexPatternFactory = dataDriftRouteIndexPatternFactory;
const PageWrapper = ({
  mode
}) => {
  const {
    context
  } = (0, _use_resolver.useRouteResolver)('full', [], (0, _resolvers.basicResolvers)());
  return /*#__PURE__*/_react.default.createElement(_router.PageLoader, {
    context: context,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_ml.DataSourceContextProvider, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 105,
      columnNumber: 7
    }
  }, mode === _locator.ML_PAGES.DATA_DRIFT_INDEX_SELECT ? /*#__PURE__*/_react.default.createElement(_index_patterns_picker.DataDriftIndexOrSearchRedirect, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 107,
      columnNumber: 11
    }
  }) : /*#__PURE__*/_react.default.createElement(_index_patterns_picker.DataDriftIndexPatternsPicker, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 11
    }
  })));
};