"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExplorerChartDistribution = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react = _interopRequireDefault(require("react"));
var _d = _interopRequireDefault(require("d3"));
var _moment = _interopRequireDefault(require("moment"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _mlAnomalyUtils = require("@kbn/ml-anomaly-utils");
var _mlDateUtils = require("@kbn/ml-date-utils");
var _public = require("@kbn/kibana-react-plugin/public");
var _anomalies_table_utils = require("../../../../common/util/anomalies_table_utils");
var _links_menu = require("../../components/anomalies_table/links_menu");
var _rule_editor = require("../../components/rule_editor");
var _format_value = require("../../formatters/format_value");
var _chart_utils = require("../../util/chart_utils");
var _loading_indicator = require("../../components/loading_indicator/loading_indicator");
var _explorer_constants = require("../explorer_constants");
var _constants = require("./constants");
var _rxjs = require("rxjs");
var _draw_anomaly_explorer_charts_cursor = require("./utils/draw_anomaly_explorer_charts_cursor");
var _charts = require("../../../../common/constants/charts");
var _explorer_chart_styles = require("./explorer_chart_styles");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/explorer/explorer_charts/explorer_chart_distribution.js";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
/*
 * React component for rendering a chart of anomalies in the raw data in
 * the Machine Learning Explorer dashboard.
 */
const popoverMenuOffset = 0;
const CONTENT_WRAPPER_HEIGHT = 215;
const SCHEDULED_EVENT_MARKER_HEIGHT = 5;

// If a rare/event-distribution chart has a cardinality of 10 or less,
// then the chart will display the y axis labels for each lane of events.
// If cardinality is higher, then the axis will just be hidden.
// Cardinality in this case refers to the available for display,
// not the cardinality of the full source data set.
const Y_AXIS_LABEL_THRESHOLD = 10;
class ExplorerChartDistribution extends _react.default.Component {
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "setShowRuleEditorFlyoutFunction", func => {
      this.setState({
        showRuleEditorFlyout: func
      });
    });
    (0, _defineProperty2.default)(this, "unsetShowRuleEditorFlyoutFunction", () => {
      this.setState({
        showRuleEditorFlyout: () => {}
      });
    });
    this.chartScales = undefined;
    this.cursorStateSubscription = undefined;
    this.state = {
      popoverData: null,
      popoverCoords: [0, 0],
      showRuleEditorFlyout: () => {}
    };
  }
  componentDidMount() {
    this.renderChart();
    this.cursorStateSubscription = this.props.cursor$.pipe((0, _rxjs.filter)(c => c.isDateHistogram)).subscribe(cursor => {
      (0, _draw_anomaly_explorer_charts_cursor.drawCursor)(cursor.cursor, this.rootNode, this.props.id, this.props.seriesConfig, this.chartScales, this.props.chartTheme);
    });
  }
  componentWillUnmount() {
    var _this$cursorStateSubs;
    (_this$cursorStateSubs = this.cursorStateSubscription) === null || _this$cursorStateSubs === void 0 ? void 0 : _this$cursorStateSubs.unsubscribe();
  }
  componentDidUpdate() {
    this.renderChart();
  }
  renderChart() {
    const {
      tooManyBuckets,
      tooltipService,
      timeBuckets,
      showSelectedInterval,
      onPointerUpdate,
      id: chartId
    } = this.props;
    const element = this.rootNode;
    const config = this.props.seriesConfig;
    const severity = this.props.severity;
    const euiTheme = this.props.euiTheme;
    if (typeof config === 'undefined' || Array.isArray(config.chartData) === false) {
      // just return so the empty directive renders without an error later on
      return;
    }
    const fieldFormat = this.context.services.mlServices.mlFieldFormatService.getFieldFormat(config.jobId, config.detectorIndex);
    let vizWidth = 0;
    const chartType = (0, _chart_utils.getChartType)(config);

    // Left margin is adjusted later for longest y-axis label.
    const margin = {
      top: 10,
      right: 0,
      bottom: 30,
      left: 0
    };
    if (chartType === _explorer_constants.CHART_TYPE.POPULATION_DISTRIBUTION) {
      margin.left = 60;
    }
    let lineChartXScale = null;
    let lineChartYScale = null;
    let lineChartGroup;
    let lineChartValuesLine = null;
    const CHART_Y_ATTRIBUTE = chartType === _explorer_constants.CHART_TYPE.EVENT_DISTRIBUTION ? 'entity' : 'value';
    let highlight = config.chartData.find(d => d.anomalyScore !== undefined);
    highlight = highlight && highlight.entity;
    const filteredChartData = init(config);
    drawRareChart(filteredChartData);
    function init({
      chartData,
      functionDescription
    }) {
      // Clear any existing elements from the visualization,
      // then build the svg elements for the chart.
      const chartElement = _d.default.select(element).select('.content-wrapper');
      chartElement.select('svg').remove();
      const svgWidth = element.clientWidth;
      const svgHeight = _constants.CHART_HEIGHT + margin.top + margin.bottom;
      const svg = chartElement.append('svg').classed('ml-explorer-chart-svg', true).attr('id', 'ml-explorer-chart-svg' + chartId).attr('width', svgWidth).attr('height', svgHeight);
      const categoryLimit = 30;
      const scaleCategories = _d.default.nest().key(d => d.entity).entries(chartData).sort((a, b) => {
        // To display calendar event markers we populate the chart with fake data points.
        // If a category has fake data points, it should be sorted to the end.
        const aHasFakeData = a.values.some(d => d.entity === _charts.SCHEDULE_EVENT_MARKER_ENTITY);
        const bHasFakeData = b.values.some(d => d.entity === _charts.SCHEDULE_EVENT_MARKER_ENTITY);
        if (aHasFakeData && !bHasFakeData) {
          return 1;
        }
        if (bHasFakeData && !aHasFakeData) {
          return -1;
        }
        return b.values.length - a.values.length;
      }).filter((d, i) => {
        // only filter for rare charts
        if (chartType === _explorer_constants.CHART_TYPE.EVENT_DISTRIBUTION) {
          return i < categoryLimit || d.key === highlight || d.values.some(d => d.entity === _charts.SCHEDULE_EVENT_MARKER_ENTITY);
        }
        return true;
      }).map(d => d.key);
      chartData = chartData.filter(d => {
        return scaleCategories.includes(d.entity);
      });
      if (chartType === _explorer_constants.CHART_TYPE.POPULATION_DISTRIBUTION) {
        const focusData = chartData.filter(d => {
          return d.entity === highlight;
        });
        // calculate the max y domain based on value, typical, and actual
        // also sets the min to be at least 0 if the series function type is `count`
        const {
          min: yScaleDomainMin,
          max: yScaleDomainMax
        } = (0, _chart_utils.chartExtendedLimits)(focusData, functionDescription);
        // now again filter chartData to include only the data points within the domain
        chartData = chartData.filter(d => {
          return d.value <= yScaleDomainMax;
        });
        lineChartYScale = _d.default.scale.linear().range([_constants.CHART_HEIGHT, 0]).domain([yScaleDomainMin < 0 ? yScaleDomainMin : 0, yScaleDomainMax]).nice();
      } else if (chartType === _explorer_constants.CHART_TYPE.EVENT_DISTRIBUTION) {
        // avoid overflowing the border of the highlighted area
        const rowMargin = 5;
        lineChartYScale = _d.default.scale.ordinal().rangePoints([rowMargin, _constants.CHART_HEIGHT - rowMargin]).domain(scaleCategories);
      } else {
        throw new Error(`chartType '${chartType}' not supported`);
      }
      const yAxis = _d.default.svg.axis().scale(lineChartYScale).orient('left').innerTickSize(0).outerTickSize(0).tickPadding(10);
      let maxYAxisLabelWidth = 0;
      const tempLabelText = svg.append('g').attr('class', 'temp-axis-label tick');
      const tempLabelTextData = chartType === _explorer_constants.CHART_TYPE.POPULATION_DISTRIBUTION ? lineChartYScale.ticks() : scaleCategories;
      tempLabelText.selectAll('text.temp.axis').data(tempLabelTextData).enter().append('text').text(d => {
        if (fieldFormat !== undefined) {
          return fieldFormat.convert(d, 'text');
        } else {
          if (chartType === _explorer_constants.CHART_TYPE.POPULATION_DISTRIBUTION) {
            return lineChartYScale.tickFormat()(d);
          }
          return d;
        }
      })
      // Don't use an arrow function since we need access to `this`.
      .each(function () {
        maxYAxisLabelWidth = Math.max(this.getBBox().width + yAxis.tickPadding(), maxYAxisLabelWidth);
      }).remove();
      _d.default.select('.temp-axis-label').remove();

      // Set the size of the left margin according to the width of the largest y axis tick label
      // if the chart is either a population chart or a rare chart below the cardinality threshold.
      if (chartType === _explorer_constants.CHART_TYPE.POPULATION_DISTRIBUTION || chartType === _explorer_constants.CHART_TYPE.EVENT_DISTRIBUTION && scaleCategories.length <= Y_AXIS_LABEL_THRESHOLD) {
        margin.left = Math.max(maxYAxisLabelWidth, 40);
      }
      vizWidth = svgWidth - margin.left - margin.right;

      // Set the x axis domain to match the request plot range.
      // This ensures ranges on different charts will match, even when there aren't
      // data points across the full range, and the selected anomalous region is centred.
      lineChartXScale = _d.default.time.scale().range([0, vizWidth]).domain([config.plotEarliest, config.plotLatest]);
      lineChartValuesLine = _d.default.svg.line().x(d => lineChartXScale(d.date)).y(d => lineChartYScale(d[CHART_Y_ATTRIBUTE])).defined(d => d.value !== null);
      lineChartGroup = svg.append('g').attr('class', 'line-chart').attr('transform', 'translate(' + margin.left + ',' + margin.top + ')');
      return chartData;
    }
    function drawRareChart(data) {
      // Add border round plot area.
      lineChartGroup.append('rect').attr('x', 0).attr('y', 0).attr('height', _constants.CHART_HEIGHT).attr('width', vizWidth).style('stroke', euiTheme.colors.lightestShade).style('fill', 'none').style('stroke-width', 1);
      drawRareChartAxes();
      drawRareChartHighlightedSpan();
      drawCursorListener(lineChartGroup);
      drawRareChartDots(data, lineChartGroup, lineChartValuesLine);
      drawRareChartMarkers(data);
    }
    function drawCursorListener(lineChartGroup) {
      lineChartGroup.append('rect').attr('x', 0).attr('y', 0).attr('height', _constants.CHART_HEIGHT).attr('width', vizWidth).on('mouseout', function () {
        onPointerUpdate({
          chartId: 'ml-anomaly-chart-metric',
          scale: 'time',
          smHorizontalValue: null,
          smVerticalValue: null,
          type: 'Out',
          unit: undefined
        });
      }).on('mousemove', function () {
        const mouse = _d.default.mouse(this);
        if (onPointerUpdate) {
          onPointerUpdate({
            chartId: 'ml-anomaly-chart-metric',
            scale: 'time',
            smHorizontalValue: null,
            smVerticalValue: null,
            type: 'Over',
            unit: undefined,
            x: (0, _moment.default)(lineChartXScale.invert(mouse[0])).unix() * 1000
          });
        }
      }).style('fill', _constants.TRANSPARENT_BACKGROUND);
    }
    function drawRareChartAxes() {
      // Get the scaled date format to use for x axis tick labels.
      const bounds = {
        min: (0, _moment.default)(config.plotEarliest),
        max: (0, _moment.default)(config.plotLatest)
      };
      timeBuckets.setBounds(bounds);
      timeBuckets.setInterval('auto');
      const xAxisTickFormat = timeBuckets.getScaledDateFormat();
      const tickValuesStart = Math.max(config.selectedEarliest, config.plotEarliest);
      // +1 ms to account for the ms that was subtracted for query aggregations.
      const interval = config.selectedLatest - config.selectedEarliest + 1;
      const xAxis = _d.default.svg.axis().scale(lineChartXScale).orient('bottom').innerTickSize(-_constants.CHART_HEIGHT).outerTickSize(0).tickPadding(10).tickFormat(d => (0, _moment.default)(d).format(xAxisTickFormat));

      // With tooManyBuckets, or when the chart is used as an embeddable,
      // the chart would end up with no x-axis labels because the ticks are based on the span of the
      // emphasis section, and the selected area spans the whole chart.
      const useAutoTicks = tooManyBuckets === true || interval >= config.plotLatest - config.plotEarliest;
      if (useAutoTicks === false) {
        const tickValues = (0, _chart_utils.getTickValues)(tickValuesStart, interval, config.plotEarliest, config.plotLatest);
        xAxis.tickValues(tickValues);
      } else {
        xAxis.ticks((0, _chart_utils.numTicksForDateFormat)(vizWidth, xAxisTickFormat));
      }
      const yAxis = _d.default.svg.axis().scale(lineChartYScale).orient('left').innerTickSize(0).outerTickSize(0).tickPadding(10).tickFormat(d => d === _charts.SCHEDULE_EVENT_MARKER_ENTITY ? null : d);
      if (fieldFormat !== undefined) {
        yAxis.tickFormat(d => fieldFormat.convert(d, 'text'));
      }
      const axes = lineChartGroup.append('g');
      const gAxis = axes.append('g').attr('class', 'x axis').attr('transform', 'translate(0,' + _constants.CHART_HEIGHT + ')').call(xAxis);
      axes.append('g').attr('class', 'y axis').call(yAxis);

      // emphasize the y axis label this rare chart is actually about
      if (chartType === _explorer_constants.CHART_TYPE.EVENT_DISTRIBUTION) {
        axes.select('.y').selectAll('text').each(function (d) {
          _d.default.select(this).classed('ml-explorer-chart-axis-emphasis', d === highlight);
        });
      }
      if (useAutoTicks === false) {
        (0, _chart_utils.removeLabelOverlap)(gAxis, tickValuesStart, interval, vizWidth);
      }
    }
    function drawRareChartDots(dotsData, rareChartGroup, rareChartValuesLine, radius = 1.5) {
      // check if `g.values-dots` already exists, if not create it
      // in both cases assign the element to `dotGroup`
      const dotGroup = rareChartGroup.select('.values-dots').empty() ? rareChartGroup.append('g').classed('values-dots', true) : rareChartGroup.select('.values-dots');

      // use d3's enter/update/exit pattern to render the dots
      const dots = dotGroup.selectAll('circle').data(dotsData);
      dots.enter().append('circle').classed('values-dots-circle', true).classed('values-dots-circle-blur', d => {
        return d.entity !== highlight;
      }).attr('r', d => d.entity === highlight ? radius * 1.5 : radius);
      dots.attr('cx', rareChartValuesLine.x()).attr('cy', rareChartValuesLine.y());
      dots.exit().remove();
    }
    const that = this;
    function drawRareChartHighlightedSpan() {
      if (showSelectedInterval === false) return;
      // Draws a rectangle which highlights the time span that has been selected for view.
      // Note depending on the overall time range and the bucket span, the selected time
      // span may be longer than the range actually being plotted.
      const rectStart = Math.max(config.selectedEarliest, config.plotEarliest);
      const rectEnd = Math.min(config.selectedLatest, config.plotLatest);
      const rectWidth = lineChartXScale(rectEnd) - lineChartXScale(rectStart);
      lineChartGroup.append('rect').attr('class', 'selected-interval').attr('x', lineChartXScale(new Date(rectStart)) + 2).attr('y', 2).attr('rx', 3).attr('ry', 3).attr('width', rectWidth - 4).attr('height', _constants.CHART_HEIGHT - 4);
    }
    function drawRareChartMarkers(data) {
      // Render circle markers for the points.
      // These are used for displaying tooltips on mouseover.
      // Don't render dots where value=null (data gaps)
      const dots = lineChartGroup.append('g').attr('class', 'chart-markers').selectAll('.metric-value').data(data.filter(d => d.value !== null));

      // Remove dots that are no longer needed i.e. if number of chart points has decreased.
      dots.exit().remove();
      // Create any new dots that are needed i.e. if number of chart points has increased.
      dots.enter().append('circle').attr('r', _chart_utils.LINE_CHART_ANOMALY_RADIUS).on('click', function (d) {
        _d.default.event.preventDefault();
        if (d.anomalyScore === undefined) return;
        showAnomalyPopover(d, this);
      })
      // Don't use an arrow function since we need access to `this`.
      .on('mouseover', function (d) {
        showLineChartTooltip(d, this);
      }).on('mouseout', () => tooltipService.hide());

      // Update all dots to new positions.
      dots.attr('cx', d => lineChartXScale(d.date)).attr('cy', d => lineChartYScale(d[CHART_Y_ATTRIBUTE])).attr('class', d => {
        let markerClass = 'metric-value';
        if (d.anomalyScore !== undefined) {
          // Check if the anomaly score falls within any of the selected severity ranges
          const anomalyScore = Number(d.anomalyScore);
          const isInSelectedRange = severity.some(s => {
            return anomalyScore >= s.min && (s.max === undefined || anomalyScore <= s.max);
          });
          if (isInSelectedRange) {
            markerClass += ' anomaly-marker ';
            markerClass += (0, _mlAnomalyUtils.getSeverityWithLow)(anomalyScore).id;
          }
        }
        return markerClass;
      });

      // Add rectangular markers for any scheduled events.
      const scheduledEventMarkers = lineChartGroup.select('.chart-markers').selectAll('.scheduled-event-marker').data(data.filter(d => d.scheduledEvents !== undefined));

      // Remove markers that are no longer needed i.e. if number of chart points has decreased.
      scheduledEventMarkers.exit().remove();
      // Create any new markers that are needed i.e. if number of chart points has increased.
      scheduledEventMarkers.enter().append('rect').attr('width', _chart_utils.LINE_CHART_ANOMALY_RADIUS * 2).attr('height', SCHEDULED_EVENT_MARKER_HEIGHT).attr('class', 'scheduled-event-marker').attr('rx', 1).attr('ry', 1);

      // Update all markers to new positions.
      scheduledEventMarkers.attr('x', d => lineChartXScale(d.date) - _chart_utils.LINE_CHART_ANOMALY_RADIUS).attr('y', d => lineChartYScale(d[CHART_Y_ATTRIBUTE]) - SCHEDULED_EVENT_MARKER_HEIGHT / 2);
    }
    function showAnomalyPopover(marker, circle) {
      const anomalyTime = marker.date;
      const tableItem = (0, _anomalies_table_utils.getTableItemClosestToTimestamp)(that.props.tableData.anomalies, anomalyTime, that.props.seriesConfig.entityFields);
      if (tableItem) {
        // Overwrite the timestamp of the possibly aggregated table item with the
        // timestamp of the anomaly clicked in the chart so we're able to pick
        // the right baseline and deviation time ranges for Log Rate Analysis.
        tableItem.source.timestamp = anomalyTime;

        // Calculate the relative coordinates of the clicked anomaly marker
        // so we're able to position the popover actions menu above it.
        const dotRect = circle.getBoundingClientRect();
        const rootRect = that.rootNode.getBoundingClientRect();
        const x = Math.round(dotRect.x + dotRect.width / 2 - rootRect.x);
        const y = Math.round(dotRect.y + dotRect.height / 2 - rootRect.y) - popoverMenuOffset;

        // Hide any active tooltip
        that.props.tooltipService.hide();
        // Set the popover state to enable the actions menu
        that.setState({
          popoverData: tableItem,
          popoverCoords: [x, y]
        });
      }
    }
    function showLineChartTooltip(marker, circle) {
      // Show the time and metric values in the tooltip.
      // Uses date, value, upper, lower and anomalyScore (optional) marker properties.
      const formattedDate = (0, _mlDateUtils.formatHumanReadableDateTime)(marker.date);
      const tooltipData = [{
        label: formattedDate
      }];
      const seriesKey = config.detectorLabel;

      // Hide entity for scheduled events with mocked value.
      if (marker.entity !== undefined && marker.entity !== _charts.SCHEDULE_EVENT_MARKER_ENTITY) {
        tooltipData.push({
          label: _i18n.i18n.translate('xpack.ml.explorer.distributionChart.entityLabel', {
            defaultMessage: 'entity'
          }),
          value: marker.entity,
          seriesIdentifier: {
            key: seriesKey
          },
          valueAccessor: 'entity'
        });
      }
      if (marker.anomalyScore !== undefined) {
        const score = parseInt(marker.anomalyScore);
        const displayScore = (0, _mlAnomalyUtils.getFormattedSeverityScore)(score);
        tooltipData.push({
          label: _i18n.i18n.translate('xpack.ml.explorer.distributionChart.anomalyScoreLabel', {
            defaultMessage: 'anomaly score'
          }),
          value: displayScore,
          color: (0, _mlAnomalyUtils.getThemeResolvedSeverityColor)(score, euiTheme),
          seriesIdentifier: {
            key: seriesKey
          },
          valueAccessor: 'anomaly_score'
        });
        if (chartType !== _explorer_constants.CHART_TYPE.EVENT_DISTRIBUTION) {
          tooltipData.push({
            label: _i18n.i18n.translate('xpack.ml.explorer.distributionChart.valueLabel', {
              defaultMessage: 'value'
            }),
            value: (0, _format_value.formatValue)(marker.value, config.functionDescription, fieldFormat),
            seriesIdentifier: {
              key: seriesKey
            },
            valueAccessor: 'value'
          });
          if (typeof marker.numberOfCauses === 'undefined' || marker.numberOfCauses === 1) {
            tooltipData.push({
              label: _i18n.i18n.translate('xpack.ml.explorer.distributionChart.typicalLabel', {
                defaultMessage: 'typical'
              }),
              value: (0, _format_value.formatValue)(marker.typical, config.functionDescription, fieldFormat),
              seriesIdentifier: {
                key: seriesKey
              },
              valueAccessor: 'typical'
            });
          }
          if (typeof marker.byFieldName !== 'undefined' && marker.numberOfCauses !== undefined) {
            tooltipData.push({
              label: _i18n.i18n.translate('xpack.ml.explorer.distributionChart.unusualByFieldValuesLabel', {
                defaultMessage: '{ numberOfCauses, plural, one {# unusual {byFieldName} value} other {#{plusSign} unusual {byFieldName} values}}',
                values: {
                  numberOfCauses: marker.numberOfCauses,
                  byFieldName: marker.byFieldName,
                  // Maximum of 10 causes are stored in the record, so '10' may mean more than 10.
                  plusSign: marker.numberOfCauses < 10 ? '' : '+'
                }
              }),
              seriesIdentifier: {
                key: seriesKey
              },
              valueAccessor: 'numberOfCauses'
            });
          }
        }
      } else if (chartType !== _explorer_constants.CHART_TYPE.EVENT_DISTRIBUTION &&
      // Hide value for scheduled events with mocked value.
      marker.entity !== _charts.SCHEDULE_EVENT_MARKER_ENTITY) {
        tooltipData.push({
          label: _i18n.i18n.translate('xpack.ml.explorer.distributionChart.valueWithoutAnomalyScoreLabel', {
            defaultMessage: 'value'
          }),
          value: (0, _format_value.formatValue)(marker.value, config.functionDescription, fieldFormat),
          seriesIdentifier: {
            key: seriesKey
          },
          valueAccessor: 'value'
        });
      }
      if (marker.scheduledEvents !== undefined) {
        marker.scheduledEvents.forEach((scheduledEvent, i) => {
          tooltipData.push({
            label: _i18n.i18n.translate('xpack.ml.timeSeriesExplorer.timeSeriesChart.scheduledEventsLabel', {
              defaultMessage: 'scheduled event{counter}',
              values: {
                counter: marker.scheduledEvents.length > 1 ? ` #${i + 1}` : ''
              }
            }),
            value: scheduledEvent,
            seriesIdentifier: {
              key: seriesKey
            },
            valueAccessor: `scheduled_events_${i + 1}`
          });
        });
      }
      tooltipService.show(tooltipData, circle, {
        x: _chart_utils.LINE_CHART_ANOMALY_RADIUS * 3,
        y: _chart_utils.LINE_CHART_ANOMALY_RADIUS * 2
      });
    }
    this.chartScales = {
      lineChartXScale,
      margin
    };
  }
  shouldComponentUpdate() {
    // Always return true, d3 will take care of appropriate re-rendering.
    return true;
  }
  setRef(componentNode) {
    this.rootNode = componentNode;
  }
  closePopover() {
    this.setState({
      popoverData: null,
      popoverCoords: [0, 0]
    });
  }
  render() {
    const {
      seriesConfig
    } = this.props;
    if (typeof seriesConfig === 'undefined') {
      // just return so the empty directive renders without an error later on
      return null;
    }

    // create a chart loading placeholder
    const isLoading = seriesConfig.loading;
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_rule_editor.RuleEditorFlyout, {
      setShowFunction: this.setShowRuleEditorFlyoutFunction,
      unsetShowFunction: this.unsetShowRuleEditorFlyoutFunction,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 754,
        columnNumber: 9
      }
    }), this.state.popoverData !== null && /*#__PURE__*/_react.default.createElement("div", {
      style: {
        position: 'absolute',
        marginLeft: this.state.popoverCoords[0],
        marginTop: this.state.popoverCoords[1]
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 759,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
      isOpen: true,
      closePopover: () => this.closePopover(),
      panelPaddingSize: "none",
      anchorPosition: "upLeft",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 766,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_links_menu.LinksMenuUI, {
      anomaly: this.state.popoverData,
      bounds: {
        min: (0, _moment.default)(seriesConfig.plotEarliest),
        max: (0, _moment.default)(seriesConfig.plotLatest)
      },
      showMapsLink: false,
      showViewSeriesLink: true,
      isAggregatedData: this.props.tableData.interval !== 'second',
      interval: this.props.tableData.interval,
      showRuleEditorFlyout: this.state.showRuleEditorFlyout,
      onItemClick: () => this.closePopover(),
      sourceIndicesWithGeoFields: this.props.sourceIndicesWithGeoFields,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 772,
        columnNumber: 15
      }
    }))), /*#__PURE__*/_react.default.createElement("div", {
      css: _explorer_chart_styles.cssMlExplorerChart,
      ref: this.setRef.bind(this),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 789,
        columnNumber: 9
      }
    }, isLoading && /*#__PURE__*/_react.default.createElement(_loading_indicator.LoadingIndicator, {
      height: CONTENT_WRAPPER_HEIGHT,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 790,
        columnNumber: 25
      }
    }), !isLoading && /*#__PURE__*/_react.default.createElement("div", {
      className: "content-wrapper",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 791,
        columnNumber: 26
      }
    })));
  }
}
exports.ExplorerChartDistribution = ExplorerChartDistribution;
(0, _defineProperty2.default)(ExplorerChartDistribution, "contextType", _public.context);
(0, _defineProperty2.default)(ExplorerChartDistribution, "propTypes", {
  seriesConfig: _propTypes.default.object,
  severity: _propTypes.default.array,
  tableData: _propTypes.default.object,
  tooltipService: _propTypes.default.object.isRequired,
  cursor$: _propTypes.default.object,
  euiTheme: _propTypes.default.object.isRequired
});