"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExplorerNoInfluencersFound = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/explorer/components/explorer_no_influencers_found/explorer_no_influencers_found.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
/*
 * React component for rendering EuiEmptyPrompt when no influencers were found.
 */
const ExplorerNoInfluencersFound = ({
  viewBySwimlaneFieldName,
  showFilterMessage = false
}) => showFilterMessage === false ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.ml.explorer.noInfluencersFoundTitle",
  defaultMessage: "No {viewBySwimlaneFieldName} influencers found",
  values: {
    viewBySwimlaneFieldName
  },
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 21,
    columnNumber: 5
  }
}) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.ml.explorer.noInfluencersFoundTitleFilterMessage",
  defaultMessage: "No {viewBySwimlaneFieldName} influencers found for specified filter",
  values: {
    viewBySwimlaneFieldName
  },
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 27,
    columnNumber: 5
  }
});
exports.ExplorerNoInfluencersFound = ExplorerNoInfluencersFound;