"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SwimLaneWrapper = exports.MiniAlertTable = void 0;
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _lodash = require("lodash");
var _react2 = _interopRequireWildcard(require("react"));
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _i18n = require("@kbn/i18n");
var _collapsible_panel = require("../../components/collapsible_panel");
var _alerts = require("../../../../common/constants/alerts");
var _render_cell_value = require("../../../alerting/anomaly_detection_alerts_table/render_cell_value");
var _kibana = require("../../contexts/kibana");
var _anomaly_explorer_context = require("../anomaly_explorer_context");
var _swimlane_container = require("../swimlane_container");
var _const = require("./const");
var _constants = require("../constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/explorer/alerts/swim_lane_wrapper.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * Wrapper component for the swim lane
 * that handles the popover for the selected cells.
 */
const SwimLaneWrapper = ({
  children,
  selection,
  swimlaneContainerWidth,
  swimLaneData
}) => {
  var _anomalyDetectionAler;
  const {
    services: {
      fieldFormats
    }
  } = (0, _kibana.useMlKibana)();
  const containerRef = (0, _react2.useRef)(null);
  const {
    anomalyDetectionAlertsStateService,
    anomalyTimelineStateService
  } = (0, _anomaly_explorer_context.useAnomalyExplorerContext)();
  const selectedAlerts = (0, _useObservable.default)(anomalyDetectionAlertsStateService.selectedAlerts$, []);
  const leftOffset = (0, _react2.useMemo)(() => {
    if (!selection || !swimLaneData) return 0;
    const selectedCellIndex = swimLaneData.points.findIndex(v => v.time === selection.times[0]);
    const cellWidth = swimlaneContainerWidth / swimLaneData.points.length;
    const cellOffset = (selectedCellIndex + 1) * cellWidth;
    return _constants.Y_AXIS_LABEL_WIDTH + cellOffset;
  }, [selection, swimlaneContainerWidth, swimLaneData]);
  const popoverOpen = !!selection && !!(selectedAlerts !== null && selectedAlerts !== void 0 && selectedAlerts.length);
  const alertFormatter = (0, _react2.useMemo)(() => (0, _render_cell_value.getAlertEntryFormatter)(fieldFormats), [fieldFormats]);
  const viewType = 'table';
  const closePopover = (0, _react2.useCallback)(() => {
    anomalyTimelineStateService.setSelectedCells();
  }, [anomalyTimelineStateService]);
  return /*#__PURE__*/_react2.default.createElement("div", {
    ref: containerRef,
    "data-test-subj": "mlSwimLaneWrapper",
    css: (0, _react.css)`
        position: relative;
      `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react2.default.createElement("div", {
    "data-test-subj": "swimLanePopoverTriggerWrapper",
    style: {
      left: `${leftOffset}px`
    },
    css: (0, _react.css)`
          position: absolute;
          top: -${_swimlane_container.CELL_HEIGHT / 2}px;
          height: 0;
        `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 107,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiPopover, {
    button: /*#__PURE__*/_react2.default.createElement("button", {
      "data-test-subj": "mlSwimLanePopoverTrigger",
      css: (0, _react.css)`
                position: absolute;
                top: 0;
                visibility: hidden;
              `,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 118,
        columnNumber: 13
      }
    }),
    isOpen: popoverOpen,
    anchorPosition: "upCenter",
    hasArrow: true,
    repositionOnScroll: true,
    closePopover: closePopover,
    panelPaddingSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 116,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiPopoverTitle, {
    paddingSize: 'xs',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 134,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: 'none',
    justifyContent: 'spaceBetween',
    alignItems: 'center',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 135,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 136,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.explorer.alertsPanel.header",
    defaultMessage: "Alerts",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 137,
      columnNumber: 17
    }
  })), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 142,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: 'none',
    alignItems: 'center',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 143,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 144,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react2.default.createElement(_collapsible_panel.PanelHeaderItems, {
    compressed: true,
    headerItems: Object.entries((_anomalyDetectionAler = anomalyDetectionAlertsStateService.countAlertsByStatus(selectedAlerts !== null && selectedAlerts !== void 0 ? selectedAlerts : [])) !== null && _anomalyDetectionAler !== void 0 ? _anomalyDetectionAler : {}).map(([status, count]) => {
      return /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
        size: 'xs',
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 153,
          columnNumber: 27
        }
      }, _const.statusNameMap[status], ' ', /*#__PURE__*/_react2.default.createElement(_eui.EuiNotificationBadge, {
        size: "s",
        color: status === _ruleDataUtils.ALERT_STATUS_ACTIVE ? 'accent' : 'subdued',
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 155,
          columnNumber: 29
        }
      }, count));
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 145,
      columnNumber: 21
    }
  })), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 166,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiButtonIcon, {
    size: "s",
    color: 'text',
    iconType: 'cross',
    onClick: closePopover,
    "aria-label": _i18n.i18n.translate('xpack.ml.explorer.cellSelectionPopover.closeButtonAriaLabel', {
      defaultMessage: 'Close popover'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 167,
      columnNumber: 21
    }
  })))))), viewType === 'table' && !!(selectedAlerts !== null && selectedAlerts !== void 0 && selectedAlerts.length) ? /*#__PURE__*/_react2.default.createElement(MiniAlertTable, {
    data: selectedAlerts,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 185,
      columnNumber: 13
    }
  }) : (selectedAlerts !== null && selectedAlerts !== void 0 ? selectedAlerts : []).map(alert => {
    const fields = Object.entries((0, _lodash.pick)(alert, [_ruleDataUtils.ALERT_RULE_NAME, _alerts.ALERT_ANOMALY_DETECTION_JOB_ID, _alerts.ALERT_ANOMALY_TIMESTAMP, _ruleDataUtils.ALERT_START, _ruleDataUtils.ALERT_DURATION])).map(([prop, value]) => {
      return alertFormatter(prop, value);
    });
    return /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 201,
        columnNumber: 17
      }
    }, fields.map(({
      title,
      description
    }) => {
      return /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 204,
          columnNumber: 23
        }
      }, /*#__PURE__*/_react2.default.createElement(_eui.EuiDescriptionList, {
        compressed: true,
        listItems: [{
          title,
          description
        }],
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 205,
          columnNumber: 25
        }
      }));
    }));
  }))), children);
};
exports.SwimLaneWrapper = SwimLaneWrapper;
const ALERT_PER_PAGE = 3;
const MiniAlertTable = ({
  data
}) => {
  const {
    services: {
      fieldFormats
    }
  } = (0, _kibana.useMlKibana)();
  const alertValueFormatter = (0, _react2.useMemo)(() => (0, _render_cell_value.getAlertFormatters)(fieldFormats), [fieldFormats]);
  const columns = (0, _react2.useMemo)(() => {
    return [{
      field: _ruleDataUtils.ALERT_RULE_NAME,
      width: `150px`,
      name: _alerts.alertFieldNameMap[_ruleDataUtils.ALERT_RULE_NAME],
      sortable: true
    }, {
      field: _ruleDataUtils.ALERT_START,
      width: `200px`,
      name: _alerts.alertFieldNameMap[_ruleDataUtils.ALERT_START],
      sortable: true,
      render: value => alertValueFormatter(_ruleDataUtils.ALERT_START, value)
    }, {
      field: _ruleDataUtils.ALERT_DURATION,
      width: `110px`,
      name: _alerts.alertFieldNameMap[_ruleDataUtils.ALERT_DURATION],
      sortable: true,
      render: value => alertValueFormatter(_ruleDataUtils.ALERT_DURATION, value)
    }];
  }, [alertValueFormatter]);
  return /*#__PURE__*/_react2.default.createElement(_eui.EuiInMemoryTable, {
    css: {
      width: '510px'
    },
    compressed: true,
    columns: columns,
    items: data,
    sorting: {
      sort: {
        field: _ruleDataUtils.ALERT_START,
        direction: 'asc'
      }
    },
    pagination: data.length > ALERT_PER_PAGE ? {
      compressed: true,
      initialPageSize: ALERT_PER_PAGE,
      pageSizeOptions: [3, 5, 10]
    } : false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 260,
      columnNumber: 5
    }
  });
};
exports.MiniAlertTable = MiniAlertTable;