"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useMapAction = void 0;
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _mlUrlState = require("@kbn/ml-url-state");
var _kibana = require("../../../../../contexts/kibana");
var _locator = require("../../../../../../../common/constants/locator");
var _get_view_link_status = require("../action_view/get_view_link_status");
var _map_button = require("./map_button");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/data_frame_analytics/pages/analytics_management/components/action_map/use_map_action.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const useMapAction = () => {
  const mlLocator = (0, _kibana.useMlLocator)();
  const navigateToPath = (0, _kibana.useNavigateToPath)();
  const [globalState] = (0, _mlUrlState.useUrlState)('_g');
  const clickHandler = (0, _react.useCallback)(async item => {
    const globalStateClone = (0, _lodash.cloneDeep)(globalState || {});
    delete globalStateClone.ml;
    const path = await mlLocator.getUrl({
      page: _locator.ML_PAGES.DATA_FRAME_ANALYTICS_MAP,
      pageState: {
        jobId: item.id,
        globalState: globalStateClone
      }
    });
    await navigateToPath(path, false);
  },
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [globalState]);
  const action = (0, _react.useMemo)(() => ({
    isPrimary: true,
    name: item => /*#__PURE__*/_react.default.createElement(_map_button.MapButton, {
      item: item,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 50,
        columnNumber: 50
      }
    }),
    enabled: item => !(0, _get_view_link_status.getViewLinkStatus)(item).disabled,
    description: _map_button.mapActionButtonText,
    icon: 'graphApp',
    type: 'icon',
    onClick: clickHandler,
    'data-test-subj': 'mlAnalyticsJobMapButton'
  }), [clickHandler]);
  return {
    action
  };
};
exports.useMapAction = useMapAction;