"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TimeIntervalControl = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _mlValidators = require("@kbn/ml-validators");
var _util = require("../application/jobs/new_job/common/job_validator/util");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/alerting/time_interval_control.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const TimeIntervalControl = ({
  value,
  onChange,
  label,
  ...fieldTextProps
}) => {
  const validators = (0, _react.useMemo)(() => (0, _mlValidators.composeValidators)((0, _mlValidators.timeIntervalInputValidator)()), []);

  // eslint-disable-next-line react-hooks/exhaustive-deps
  const validationErrors = (0, _react.useMemo)(() => validators(value), [value]);
  const isInvalid = !!value && !!validationErrors;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: label,
    isInvalid: isInvalid,
    error: (0, _util.invalidTimeIntervalMessage)(value !== null && value !== void 0 ? value : undefined),
    "data-test-subj": 'mlAnomalyAlertAdvancedSettingsLookbackInterval',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 38,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, (0, _extends2.default)({}, fieldTextProps, {
    placeholder: "15d, 6m",
    value: value !== null && value !== void 0 ? value : '',
    onChange: e => {
      onChange(e.target.value);
    },
    isInvalid: isInvalid,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 44,
      columnNumber: 7
    }
  })));
};
exports.TimeIntervalControl = TimeIntervalControl;