"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PrometheusExporter = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _sdk = require("@elastic/opentelemetry-node/sdk");
var _exporterPrometheus = require("@opentelemetry/exporter-prometheus");
function _assertClassBrand(e, t, n) { if ("function" == typeof e ? e === t : e.has(t)) return arguments.length < 3 ? t : n; throw new TypeError("Private element is not present on this object"); } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
/**
 * Prometheus exporter for OpenTelemetry with a custom extension to collect the metrics whenever
 * the Prometheus HTTP endpoint is called.
 *
 * The Prometheus HTTP endpoint is registered in the plugin monitoringCollection.
 * @privateRemarks x-pack/platform/plugins/private/monitoring_collection/server/routes/api/v1/prometheus/get_metrics.ts
 */
class PrometheusExporter extends _sdk.metrics.MetricReader {
  /**
   * Gets the singleton PrometheusExporter instance.
   */
  static get() {
    if (!_assertClassBrand(PrometheusExporter, this, _instance)._) {
      _instance._ = _assertClassBrand(PrometheusExporter, this, new PrometheusExporter());
    }
    return _assertClassBrand(PrometheusExporter, this, _instance)._;
  }

  /**
   * Destroys the singleton PrometheusExporter instance.
   * @privateRemarks Mostly used for testing purposes because the same exporter cannot be reassigned to new MetricsProvider.
   */
  static destroy() {
    var _assertClassBrand$_;
    (_assertClassBrand$_ = _assertClassBrand(PrometheusExporter, this, _instance)._) === null || _assertClassBrand$_ === void 0 ? void 0 : _assertClassBrand$_.shutdown();
    _instance._ = _assertClassBrand(PrometheusExporter, this, undefined);
  }
  constructor() {
    super();
    (0, _defineProperty2.default)(this, "prefix", void 0);
    (0, _defineProperty2.default)(this, "appendTimestamp", void 0);
    (0, _defineProperty2.default)(this, "serializer", void 0);
    this.prefix = _exporterPrometheus.PrometheusExporter.DEFAULT_OPTIONS.prefix;
    this.appendTimestamp = _exporterPrometheus.PrometheusExporter.DEFAULT_OPTIONS.appendTimestamp;
    this.serializer = new _exporterPrometheus.PrometheusSerializer(this.prefix, this.appendTimestamp);
  }

  /**
   * Forces the AggregationTemporality to be CUMULATIVE (as required by the Prometheus format).
   */
  selectAggregationTemporality() {
    return _sdk.metrics.AggregationTemporality.CUMULATIVE;
  }

  /**
   * Implementation of the MetricReader interface onForceFlush (noop).
   * @protected
   */
  onForceFlush() {
    return Promise.resolve(undefined);
  }

  /**
   * Implementation of the MetricReader interface onShutdown (noop).
   * @protected
   */
  onShutdown() {
    return Promise.resolve(undefined);
  }

  /**
   * Responds to incoming message with current state of all metrics.
   * @param res {@link KibanaResponseFactory}
   */
  async exportMetrics(res) {
    try {
      const collectionResult = await this.collect();
      const {
        resourceMetrics,
        errors
      } = collectionResult;
      if (errors.length) {
        return res.customError({
          statusCode: 500,
          body: `PrometheusExporter: Metrics collection errors ${errors}`
        });
      }
      const result = this.serializer.serialize(resourceMetrics);
      if (result === '') {
        return res.noContent();
      }
      return res.ok({
        body: result
      });
    } catch (error) {
      return res.customError({
        statusCode: 500,
        body: {
          message: `PrometheusExporter: Failed to export metrics ${error}`
        }
      });
    }
  }
}
exports.PrometheusExporter = PrometheusExporter;
/**
 * The singleton PrometheusExporter instance.
 * @private
 */
var _instance = {
  _: void 0
};