"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PipelineEditView = void 0;
var _react = _interopRequireWildcard(require("react"));
var _usePromise = _interopRequireDefault(require("react-use/lib/usePromise"));
var _i18n = require("@kbn/i18n");
var _pipeline_editor = require("./components/pipeline_editor");
var _pipeline = require("../models/pipeline");
var Breadcrumbs = _interopRequireWildcard(require("./breadcrumbs"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/logstash/public/application/pipeline_edit_view.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const usePipeline = (pipelineService, logstashLicenseService, toasts, shouldClone, id) => {
  const mounted = (0, _usePromise.default)();
  const [pipeline, setPipeline] = (0, _react.useState)(null);
  (0, _react.useLayoutEffect)(() => {
    (async () => {
      if (!id) {
        return setPipeline(new _pipeline.Pipeline());
      }
      try {
        const result = await mounted(pipelineService.loadPipeline(id));
        setPipeline(shouldClone ? result.clone : result);
      } catch (e) {
        await logstashLicenseService.checkValidity();
        if (e.status !== 403) {
          toasts.addDanger(_i18n.i18n.translate('xpack.logstash.couldNotLoadPipelineErrorNotification', {
            defaultMessage: `Couldn't load pipeline. Error: ''{errStatusText}''.`,
            values: {
              errStatusText: e.statusText
            }
          }));
        }
      }
    })();
  }, [pipelineService, id, mounted, shouldClone, logstashLicenseService, toasts]);
  return pipeline;
};
const PipelineEditView = ({
  pipelineService,
  logstashLicenseService,
  toasts,
  history,
  setBreadcrumbs,
  id
}) => {
  const params = new URLSearchParams(history.location.search);
  const shouldClone = params.get('clone') === '';
  const pipeline = usePipeline(pipelineService, logstashLicenseService, toasts, shouldClone, id);
  const close = (0, _react.useCallback)(() => {
    history.push('/');
  }, [history]);
  const open = (0, _react.useCallback)(newId => {
    history.push(`/pipeline/${newId}/edit`);
  }, [history]);
  if (!pipeline) {
    return null;
  }
  const isNewPipeline = !pipeline.id;
  setBreadcrumbs(isNewPipeline ? Breadcrumbs.getPipelineCreateBreadcrumbs() : Breadcrumbs.getPipelineEditBreadcrumbs(pipeline.id));
  return /*#__PURE__*/_react.default.createElement(_pipeline_editor.PipelineEditor, {
    id: id,
    clone: shouldClone,
    close: close,
    open: open,
    isNewPipeline: isNewPipeline,
    pipeline: pipeline,
    pipelineService: pipelineService,
    toastNotifications: toasts,
    licenseService: logstashLicenseService,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 5
    }
  });
};
exports.PipelineEditView = PipelineEditView;