"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.transformIn = transformIn;
var _constants = require("../../constants");
var _references = require("./references");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function transformIn(state) {
  if (state.savedObjectId) {
    const {
      savedObjectId,
      ...rest
    } = state;
    return {
      state: rest,
      references: [{
        name: 'savedObjectRef',
        type: _constants.LINKS_SAVED_OBJECT_TYPE,
        id: savedObjectId
      }]
    };
  }
  const {
    links,
    references
  } = (0, _references.extractReferences)(state.links);
  return {
    state: {
      ...state,
      links
    },
    references
  };
}