"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.permissionsSuccess = exports.permissionsLoading = exports.permissionsError = exports.loadPermissions = void 0;
var _reduxActions = require("redux-actions");
var _es = require("../../lib/es");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const permissionsLoading = exports.permissionsLoading = (0, _reduxActions.createAction)('LICENSE_MANAGEMENT_PERMISSIONS_LOADING');
const permissionsSuccess = exports.permissionsSuccess = (0, _reduxActions.createAction)('LICENSE_MANAGEMENT_PERMISSIONS_SUCCESS');
const permissionsError = exports.permissionsError = (0, _reduxActions.createAction)('LICENSE_MANAGEMENT_PERMISSIONS_ERROR');
const loadPermissions = () => async (dispatch, getState, {
  http
}) => {
  dispatch(permissionsLoading(true));
  try {
    const permissions = await (0, _es.getPermissions)(http);
    dispatch(permissionsLoading(false));
    dispatch(permissionsSuccess(permissions.hasPermission));
  } catch (e) {
    dispatch(permissionsLoading(false));
    dispatch(permissionsError(e));
  }
};
exports.loadPermissions = loadPermissions;