"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VisualOptionsPopover = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _visualizationUtils = require("@kbn/visualization-utils");
var _public = require("@kbn/expression-xy-plugin/public");
var _bar_orientation = require("../../../../shared_components/bar_orientation");
var _toolbar_divider = require("../../../../shared_components/toolbar_divider");
var _shared_components = require("../../../../shared_components");
var _missing_values_option = require("./missing_values_option");
var _line_curve_option = require("./line_curve_option");
var _fill_opacity_option = require("./fill_opacity_option");
var _point_visibility_option = require("./point_visibility_option");
var _state_helpers = require("../../state_helpers");
var _visualization_helpers = require("../../visualization_helpers");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/lens/public/visualizations/xy/xy_config_panel/visual_options_popover/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function getValueLabelDisableReason({
  isAreaPercentage,
  isHistogramSeries
}) {
  if (isHistogramSeries) {
    return _i18n.i18n.translate('xpack.lens.xyChart.valuesHistogramDisabledHelpText', {
      defaultMessage: 'This setting cannot be changed on histograms.'
    });
  }
  if (isAreaPercentage) {
    return _i18n.i18n.translate('xpack.lens.xyChart.valuesPercentageDisabledHelpText', {
      defaultMessage: 'This setting cannot be changed on percentage area charts.'
    });
  }
  return _i18n.i18n.translate('xpack.lens.xyChart.valuesStackedDisabledHelpText', {
    defaultMessage: 'This setting cannot be changed on stacked or percentage bar charts'
  });
}
const PANEL_STYLE = {
  width: 500
};
const VisualOptionsPopover = ({
  state,
  setState,
  datasourceLayers
}) => {
  var _state$fillOpacity, _state$pointVisibilit;
  const dataLayers = (0, _visualization_helpers.getDataLayers)(state.layers);
  const isAreaPercentage = dataLayers.some(({
    seriesType
  }) => seriesType === 'area_percentage_stacked');
  const isHasNonBarSeries = (0, _state_helpers.hasNonBarSeries)(dataLayers);
  const isHistogramSeries = Boolean((0, _state_helpers.hasHistogramSeries)(dataLayers, datasourceLayers));
  const isFittingEnabled = isHasNonBarSeries && !isAreaPercentage;
  const isCurveTypeEnabled = isHasNonBarSeries || isAreaPercentage;
  const valueLabelsDisabledReason = getValueLabelDisableReason({
    isAreaPercentage,
    isHistogramSeries
  });
  const isHorizontal = (0, _state_helpers.isHorizontalChart)(state.layers);
  const isDisabled = !isFittingEnabled && !isCurveTypeEnabled && isHasNonBarSeries;
  const barSeriesLayers = (0, _state_helpers.getBarSeriesLayers)(dataLayers);
  const hasAnyBarSetting = !!barSeriesLayers.length;
  const hasAreaSettings = (0, _state_helpers.hasAreaSeries)(dataLayers);
  const shouldDisplayDividerHr = !!(hasAnyBarSetting && isHasNonBarSeries);
  return /*#__PURE__*/_react.default.createElement(_visualizationUtils.TooltipWrapper, {
    tooltipContent: valueLabelsDisabledReason,
    condition: isDisabled,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_shared_components.ToolbarPopover, {
    title: _i18n.i18n.translate('xpack.lens.shared.appearanceLabel', {
      defaultMessage: 'Appearance'
    }),
    type: "visualOptions",
    groupPosition: "none",
    buttonDataTestSubj: "lnsVisualOptionsButton",
    "data-test-subj": "lnsVisualOptionsPopover",
    isDisabled: isDisabled,
    panelStyle: PANEL_STYLE,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 7
    }
  }, hasAnyBarSetting ? /*#__PURE__*/_react.default.createElement(_bar_orientation.BarOrientationSettings, {
    isDisabled: isHasNonBarSeries,
    barOrientation: isHorizontal ? 'horizontal' : 'vertical',
    onBarOrientationChange: () => {
      const newSeriesType = (0, _state_helpers.flipSeriesType)(dataLayers[0].seriesType);
      setState({
        ...state,
        layers: state.layers.map(layer => (0, _state_helpers.isBarLayer)(layer) ? {
          ...layer,
          seriesType: newSeriesType
        } : layer)
      });
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 11
    }
  }) : null, shouldDisplayDividerHr ? /*#__PURE__*/_react.default.createElement(_toolbar_divider.ToolbarDivider, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 128,
      columnNumber: 35
    }
  }) : null, hasAreaSettings ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_fill_opacity_option.FillOpacityOption, {
    isFillOpacityEnabled: true,
    value: (_state$fillOpacity = state === null || state === void 0 ? void 0 : state.fillOpacity) !== null && _state$fillOpacity !== void 0 ? _state$fillOpacity : 0.3,
    onChange: newValue => {
      setState({
        ...state,
        fillOpacity: newValue
      });
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 132,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_toolbar_divider.ToolbarDivider, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 143,
      columnNumber: 13
    }
  })) : null, /*#__PURE__*/_react.default.createElement(_point_visibility_option.PointVisibilityOption, {
    enabled: isHasNonBarSeries,
    selectedPointVisibility: (_state$pointVisibilit = state === null || state === void 0 ? void 0 : state.pointVisibility) !== null && _state$pointVisibilit !== void 0 ? _state$pointVisibilit : _public.PointVisibilityOptions.AUTO,
    onChange: newValue => {
      setState({
        ...state,
        pointVisibility: newValue
      });
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 147,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_line_curve_option.LineCurveOption, {
    enabled: isCurveTypeEnabled,
    value: state === null || state === void 0 ? void 0 : state.curveType,
    onChange: curveType => {
      setState({
        ...state,
        curveType
      });
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 158,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_missing_values_option.MissingValuesOptions, {
    isFittingEnabled: isFittingEnabled,
    fittingFunction: state === null || state === void 0 ? void 0 : state.fittingFunction,
    emphasizeFitting: state === null || state === void 0 ? void 0 : state.emphasizeFitting,
    endValue: state === null || state === void 0 ? void 0 : state.endValue,
    onFittingFnChange: newVal => {
      setState({
        ...state,
        fittingFunction: newVal
      });
    },
    onEmphasizeFittingChange: newVal => {
      setState({
        ...state,
        emphasizeFitting: newVal
      });
    },
    onEndValueChange: newVal => {
      setState({
        ...state,
        endValue: newVal
      });
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 168,
      columnNumber: 9
    }
  })));
};
exports.VisualOptionsPopover = VisualOptionsPopover;