"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BucketNestingEditor = BucketNestingEditor;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _pure_utils = require("../pure_utils");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/lens/public/datasources/form_based/dimension_panel/bucket_nesting_editor.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function nestColumn(columnOrder, outer, inner) {
  const result = columnOrder.filter(c => c !== inner);
  const outerPosition = result.indexOf(outer);
  result.splice(outerPosition + 1, 0, inner);
  return result;
}
function getFieldName(column, getFieldByName) {
  var _getFieldByName;
  return (0, _pure_utils.hasField)(column) ? ((_getFieldByName = getFieldByName(column.sourceField)) === null || _getFieldByName === void 0 ? void 0 : _getFieldByName.displayName) || column.sourceField : '';
}
function BucketNestingEditor({
  columnId,
  layer,
  setColumns,
  getFieldByName
}) {
  const column = layer.columns[columnId];
  const columns = Object.entries(layer.columns);
  const aggColumns = columns.filter(([id, c]) => id !== columnId && c.isBucketed).map(([value, c]) => ({
    value,
    text: c.label,
    fieldName: getFieldName(c, getFieldByName),
    operationType: c.operationType
  }));
  if (!column || !column.isBucketed || !aggColumns.length) {
    return null;
  }
  const prevColumn = layer.columnOrder[layer.columnOrder.indexOf(columnId) - 1];
  if (aggColumns.length === 1) {
    const [target] = aggColumns;
    const useAsTopLevelAggCopy = _i18n.i18n.translate('xpack.lens.indexPattern.useAsTopLevelAgg', {
      defaultMessage: 'Aggregate by this dimension first'
    });
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 69,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      display: "rowCompressed",
      hasChildLabel: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 70,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
      label: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "xs",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 72,
          columnNumber: 20
        }
      }, useAsTopLevelAggCopy),
      "data-test-subj": "indexPattern-nesting-switch",
      name: "nestingSwitch",
      checked: !prevColumn,
      onChange: () => {
        if (prevColumn) {
          setColumns(nestColumn(layer.columnOrder, columnId, target.value));
        } else {
          setColumns(nestColumn(layer.columnOrder, target.value, columnId));
        }
      },
      compressed: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 71,
        columnNumber: 11
      }
    })));
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.lens.indexPattern.groupByDropdown', {
      defaultMessage: 'Group by'
    }),
    display: "columnCompressed",
    fullWidth: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    compressed: true,
    "data-test-subj": "indexPattern-nesting-select",
    options: [{
      value: '',
      text: _i18n.i18n.translate('xpack.lens.xyChart.nestUnderRoot', {
        defaultMessage: 'Entire data set'
      })
    }, ...aggColumns.map(({
      value,
      text
    }) => ({
      value,
      text
    }))],
    value: prevColumn,
    onChange: e => setColumns(nestColumn(layer.columnOrder, e.target.value, columnId)),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 98,
      columnNumber: 7
    }
  }));
}