"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.redirectWhenMissing = redirectWhenMissing;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _reactDom = _interopRequireDefault(require("react-dom"));
var _theme = require("../theme");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/kibana_utils/public/history/redirect_when_missing.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const MarkdownRenderer = /*#__PURE__*/_react.default.lazy(async () => {
  const {
    default: ReactMarkdown
  } = await Promise.resolve().then(() => _interopRequireWildcard(require('react-markdown')));
  const WrappedRenderer = ({
    basePath,
    children
  }) => /*#__PURE__*/_react.default.createElement(ReactMarkdown, {
    transformLinkUri: href => ReactMarkdown.uriTransformer(basePath.prepend(href)),
    children: children,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 30,
      columnNumber: 5
    }
  });
  return {
    default: WrappedRenderer
  };
});
const ErrorRenderer = props => /*#__PURE__*/_react.default.createElement(_react.default.Suspense, {
  fallback: /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 40,
      columnNumber: 29
    }
  }),
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 40,
    columnNumber: 3
  }
}, /*#__PURE__*/_react.default.createElement(MarkdownRenderer, (0, _extends2.default)({}, props, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 41,
    columnNumber: 5
  }
})));
function addNotFoundToPath(path, error) {
  return path + (path.indexOf('?') >= 0 ? '&' : '?') + `notFound=${error.savedObjectType}&notFoundMessage=${error.message}`;
}

/**
 * Creates an error handler that will redirect to a url when a SavedObjectNotFound
 * error is thrown
 */
function redirectWhenMissing({
  history,
  navigateToApp,
  basePath,
  mapping,
  toastNotifications,
  onBeforeRedirect,
  theme,
  userProfile
}) {
  let localMappingObject;
  if (typeof mapping === 'string') {
    localMappingObject = {
      '*': mapping
    };
  } else {
    localMappingObject = mapping;
  }
  return error => {
    // if this error is not "404", rethrow
    // we can't check "error instanceof SavedObjectNotFound" since this class can live in a separate bundle
    // and the error will be an instance of other class with the same interface (actually the copy of SavedObjectNotFound class)
    if (!error.savedObjectType) {
      throw error;
    }
    let redirectTarget = localMappingObject[error.savedObjectType] || localMappingObject['*'] || '/';
    if (typeof redirectTarget !== 'string') {
      redirectTarget.path = addNotFoundToPath(redirectTarget.path, error);
    } else {
      redirectTarget = addNotFoundToPath(redirectTarget, error);
    }
    toastNotifications.addWarning({
      title: _i18n.i18n.translate('kibana_utils.history.savedObjectIsMissingNotificationMessage', {
        defaultMessage: 'Saved object is missing'
      }),
      text: element => {
        _reactDom.default.render(/*#__PURE__*/_react.default.createElement(_theme.KibanaThemeProvider, {
          theme$: theme.theme$,
          userProfile: userProfile,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 120,
            columnNumber: 11
          }
        }, /*#__PURE__*/_react.default.createElement(ErrorRenderer, {
          basePath: basePath,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 121,
            columnNumber: 13
          }
        }, error.message)), element);
        return () => _reactDom.default.unmountComponentAtNode(element);
      }
    });
    if (onBeforeRedirect) {
      onBeforeRedirect(error);
    }
    if (typeof redirectTarget !== 'string') {
      if (redirectTarget.app === 'kibana') {
        // exception for kibana app because redirect won't work right otherwise
        window.location.href = basePath.prepend(`/app/kibana${redirectTarget.path}`);
      } else {
        navigateToApp(redirectTarget.app, {
          path: redirectTarget.path
        });
      }
    } else {
      history.replace(redirectTarget);
    }
  };
}