"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NoAnomaliesFound = exports.JOB_OPTIONS = exports.AnomaliesTable = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/observability-shared-plugin/public");
var _react2 = require("@emotion/react");
var _common = require("@kbn/observability-shared-plugin/common");
var _use_waffle_options = require("../../../../pages/metrics/inventory_view/hooks/use_waffle_options");
var _constants = require("../../../../../common/constants");
var _build = require("../../../../utils/filters/build");
var _use_kibana = require("../../../../hooks/use_kibana");
var _datemath = require("../../../../utils/datemath");
var _use_sorting = require("../../../../hooks/use_sorting");
var _use_metrics_k8s_anomalies = require("../../../../pages/metrics/inventory_view/hooks/use_metrics_k8s_anomalies");
var _use_metrics_hosts_anomalies = require("../../../../pages/metrics/inventory_view/hooks/use_metrics_hosts_anomalies");
var _pagination = require("./pagination");
var _annomaly_summary = require("./annomaly_summary");
var _anomaly_severity_indicator = require("../../../logging/log_analysis_results/anomaly_severity_indicator");
var _metrics_source = require("../../../../containers/metrics_source");
var _flyout_home = require("../flyout_home");
var _use_waffle_filters = require("../../../../pages/metrics/inventory_view/hooks/use_waffle_filters");
var _use_waffle_time = require("../../../../pages/metrics/inventory_view/hooks/use_waffle_time");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/infra/public/components/ml/anomaly_detection/anomalies_table/anomalies_table.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const AnomalyActionMenu = ({
  jobId,
  type,
  startTime,
  closeFlyout,
  influencerField,
  influencers,
  disableShowInInventory,
  hostName,
  timeRange
}) => {
  const [isOpen, setIsOpen] = (0, _react.useState)(false);
  const close = (0, _react.useCallback)(() => setIsOpen(false), [setIsOpen]);
  const handleToggleMenu = (0, _react.useCallback)(() => setIsOpen(!isOpen), [isOpen]);
  const {
    setWaffleOptionsState
  } = (0, _use_waffle_options.useWaffleOptionsContext)();
  const {
    setWaffleFiltersState
  } = (0, _use_waffle_filters.useWaffleFiltersContext)();
  const {
    setWaffleTimeState
  } = (0, _use_waffle_time.useWaffleTimeContext)();
  const {
    metricsView
  } = (0, _metrics_source.useMetricsDataViewContext)();
  const {
    services: {
      share
    }
  } = (0, _use_kibana.useKibanaContextForPlugin)();
  const hostsLocator = share.url.locators.get(_common.HOSTS_LOCATOR_ID);
  const showInInventory = (0, _react.useCallback)(() => {
    const metricTypeMap = {
      memory_usage: 'memory',
      network_in: 'rx',
      network_out: 'tx'
    };
    // parse the anomaly job id for metric type
    const jobIdParts = jobId.split('-');
    const jobIdMetric = jobIdParts[jobIdParts.length - 1];
    const metricType = metricTypeMap[jobIdMetric.replace(/hosts_|k8s_/, '')];
    setWaffleOptionsState({
      metric: {
        type: metricType
      },
      sort: {
        by: 'name',
        direction: 'desc'
      },
      groupBy: [],
      nodeType: type === 'metrics_k8s' ? 'pod' : 'host',
      view: 'map',
      customOptions: [],
      customMetrics: [],
      boundsOverride: {
        max: 1,
        min: 0
      },
      autoBounds: true,
      accountId: '',
      region: ''
    });
    setWaffleTimeState({
      currentTime: startTime,
      isAutoReloading: false
    });
    setWaffleFiltersState({
      query: {
        query: influencers.reduce((query, i) => {
          if (query) {
            query = `${query} or `;
          }
          return `${query} ${influencerField}: "${i}"`;
        }, ''),
        language: 'kuery'
      }
    });
    if (closeFlyout) closeFlyout();
  }, [closeFlyout, influencerField, influencers, jobId, setWaffleFiltersState, setWaffleOptionsState, setWaffleTimeState, startTime, type]);
  const anomaliesUrl = (0, _public.useLinkProps)({
    app: 'ml',
    pathname: `/explorer?_g=${(0, _flyout_home.createResultsUrl)([jobId.toString()])}`
  });
  const items = [/*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, (0, _extends2.default)({
    key: "openInAnomalyExplorer",
    icon: "popout",
    "data-test-subj": "infraAnomalyFlyoutOpenInAnomalyExplorer"
  }, anomaliesUrl, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 161,
      columnNumber: 5
    }
  }), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.ml.anomalyFlyout.actions.openInAnomalyExplorer",
    defaultMessage: "Open in Anomaly Explorer",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 167,
      columnNumber: 7
    }
  }))];
  if (!disableShowInInventory) {
    const buildFilter = (0, _build.buildCombinedAssetFilter)({
      field: _constants.HOST_NAME_FIELD,
      values: influencers,
      dataView: metricsView === null || metricsView === void 0 ? void 0 : metricsView.dataViewReference
    });
    let newFilter = [];
    if (!Array.isArray(buildFilter)) {
      newFilter = [buildFilter];
    }
    const showInHostsItem = !hostName ? /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
      key: "showAffectedHosts",
      icon: "search",
      "data-test-subj": "infraAnomalyFlyoutShowAffectedHosts",
      href: hostsLocator === null || hostsLocator === void 0 ? void 0 : hostsLocator.getRedirectUrl({
        dateRange: {
          from: timeRange.start,
          to: timeRange.end
        },
        filters: newFilter
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 187,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.infra.ml.anomalyFlyout.actions.showAffectedHosts",
      defaultMessage: "Show affected Hosts",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 199,
        columnNumber: 9
      }
    })) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null);
    items.push(influencerField === _constants.HOST_NAME_FIELD ? showInHostsItem : /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
      icon: "search",
      "data-test-subj": "infraAnomalyFlyoutShowInInventory",
      onClick: showInInventory,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 212,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.infra.ml.anomalyFlyout.actions.showInInventory",
      defaultMessage: "Show in Inventory",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 217,
        columnNumber: 11
      }
    })));
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    anchorPosition: "downRight",
    panelPaddingSize: "none",
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      "data-test-subj": "infraAnomalyActionMenuButton",
      iconType: "boxesHorizontal",
      onClick: handleToggleMenu,
      "aria-label": _i18n.i18n.translate('xpack.infra.ml.anomalyFlyout.actions.openActionMenu', {
        defaultMessage: 'Open'
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 231,
        columnNumber: 9
      }
    }),
    isOpen: isOpen,
    closePopover: close,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 227,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
    items: items,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 243,
      columnNumber: 7
    }
  }));
};
const NoAnomaliesFound = () => {
  const euiTheme = (0, _eui.useEuiTheme)();
  return /*#__PURE__*/_react.default.createElement("div", {
    css: (0, _react2.css)`
        align-self: center;
      `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 250,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    iconType: "eyeClosed",
    iconColor: euiTheme.euiTheme.colors.mediumShade,
    title: /*#__PURE__*/_react.default.createElement("h3", {
      "data-test-subj": "noAnomaliesFoundMsg",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 259,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.infra.ml.anomalyFlyout.anomalyTable.noAnomaliesFound",
      defaultMessage: "No anomalies found",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 260,
        columnNumber: 13
      }
    })),
    body: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.infra.ml.anomalyFlyout.anomalyTable.noAnomaliesSuggestion",
      defaultMessage: "Try modifying your search or selected time range.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 267,
        columnNumber: 11
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 255,
      columnNumber: 7
    }
  }));
};
exports.NoAnomaliesFound = NoAnomaliesFound;
const DEFAULT_DATE_RANGE = {
  from: 'now-30d',
  to: 'now'
};
const JOB_OPTIONS = exports.JOB_OPTIONS = [{
  id: `hosts`,
  label: _i18n.i18n.translate('xpack.infra.ml.anomalyFlyout.hostBtn', {
    defaultMessage: 'Hosts'
  }),
  'data-test-subj': 'anomaliesHostComboBoxItem'
}, {
  id: `k8s`,
  label: _i18n.i18n.translate('xpack.infra.ml.anomalyFlyout.podsBtn', {
    defaultMessage: 'Kubernetes Pods'
  }),
  'data-test-subj': 'anomaliesK8sComboBoxItem'
}];
const AnomaliesTable = ({
  closeFlyout,
  hostName,
  dateRange = DEFAULT_DATE_RANGE,
  hideDatePicker = false,
  fetcherOpts,
  onJobTypeChange,
  hideSelectGroup
}) => {
  const [search, setSearch] = (0, _react.useState)('');
  const trackMetric = (0, _public.useUiTracker)({
    app: 'infra_metrics'
  });
  const [timeRange, setTimeRange] = (0, _react.useState)({
    start: dateRange.from,
    end: dateRange.to
  });
  const {
    sorting,
    setSorting
  } = (0, _use_sorting.useSorting)({
    field: 'startTime',
    direction: 'desc'
  });
  const [jobType, setJobType] = (0, _react.useState)(JOB_OPTIONS[0].id);
  const [selectedJobType, setSelectedJobType] = (0, _react.useState)([JOB_OPTIONS[0]]);
  const {
    source
  } = (0, _metrics_source.useSourceContext)();
  const anomalyThreshold = source === null || source === void 0 ? void 0 : source.configuration.anomalyThreshold;
  const onTimeChange = (0, _react.useCallback)(({
    isInvalid,
    start: startChange,
    end: endChange
  }) => {
    if (!isInvalid) {
      setTimeRange({
        start: startChange,
        end: endChange
      });
    }
  }, []);
  const getTimeRange = (0, _react.useCallback)(() => {
    const {
      start,
      end
    } = hideDatePicker ? {
      start: dateRange.from,
      end: dateRange.to
    } : timeRange;
    return {
      start: (0, _datemath.datemathToEpochMillis)(start) || 0,
      end: (0, _datemath.datemathToEpochMillis)(end, 'up') || 0
    };
  }, [dateRange.from, dateRange.to, hideDatePicker, timeRange]);
  const anomalyParams = (0, _react.useMemo)(() => {
    const {
      start,
      end
    } = getTimeRange();
    return {
      sourceId: 'default',
      anomalyThreshold: anomalyThreshold || 0,
      startTime: start,
      endTime: end,
      defaultSortOptions: {
        direction: (sorting === null || sorting === void 0 ? void 0 : sorting.direction) || 'desc',
        field: (sorting === null || sorting === void 0 ? void 0 : sorting.field) || 'startTime'
      },
      defaultPaginationOptions: {
        pageSize: 10
      },
      search,
      hostName
    };
  }, [anomalyThreshold, getTimeRange, hostName, search, sorting === null || sorting === void 0 ? void 0 : sorting.direction, sorting === null || sorting === void 0 ? void 0 : sorting.field]);
  const {
    metricsHostsAnomalies,
    getMetricsHostsAnomalies,
    page: hostPage,
    changeSortOptions: hostChangeSort,
    fetchNextPage: hostFetchNextPage,
    fetchPreviousPage: hostFetchPrevPage,
    isPendingMetricsHostsAnomalies: hostLoading
  } = (0, _use_metrics_hosts_anomalies.useMetricsHostsAnomaliesResults)(anomalyParams, {
    request$: fetcherOpts === null || fetcherOpts === void 0 ? void 0 : fetcherOpts.requestObservable$,
    active: jobType === 'hosts' && (fetcherOpts === null || fetcherOpts === void 0 ? void 0 : fetcherOpts.autoFetch)
  });
  const {
    metricsK8sAnomalies,
    getMetricsK8sAnomalies,
    page: k8sPage,
    changeSortOptions: k8sChangeSort,
    fetchNextPage: k8sFetchNextPage,
    fetchPreviousPage: k8sFetchPrevPage,
    isPendingMetricsK8sAnomalies: k8sLoading
  } = (0, _use_metrics_k8s_anomalies.useMetricsK8sAnomaliesResults)(anomalyParams, {
    request$: fetcherOpts === null || fetcherOpts === void 0 ? void 0 : fetcherOpts.requestObservable$,
    active: jobType === 'k8s' && (fetcherOpts === null || fetcherOpts === void 0 ? void 0 : fetcherOpts.autoFetch)
  });
  const {
    page,
    isLoading,
    fetchNextPage,
    fetchPreviousPage,
    results,
    fetchAnomalies,
    handleSort
  } = (0, _react.useMemo)(() => {
    const isHost = jobType === 'hosts';
    return {
      page: isHost ? hostPage : k8sPage,
      isLoading: isHost ? hostLoading : k8sLoading,
      fetchNextPage: isHost ? hostFetchNextPage : k8sFetchNextPage,
      fetchPreviousPage: isHost ? hostFetchPrevPage : k8sFetchPrevPage,
      results: isHost ? metricsHostsAnomalies : metricsK8sAnomalies,
      fetchAnomalies: isHost ? getMetricsHostsAnomalies : getMetricsK8sAnomalies,
      handleSort: isHost ? hostChangeSort : k8sChangeSort
    };
  }, [jobType, hostPage, k8sPage, hostLoading, k8sLoading, hostFetchNextPage, k8sFetchNextPage, hostFetchPrevPage, k8sFetchPrevPage, metricsHostsAnomalies, metricsK8sAnomalies, getMetricsHostsAnomalies, getMetricsK8sAnomalies, hostChangeSort, k8sChangeSort]);
  (0, _react.useEffect)(() => {
    fetchAnomalies();
  }, [jobType, fetchAnomalies]);
  const onSearchChange = (0, _react.useCallback)(e => {
    setSearch(e.target.value);
  }, []);
  const changeJobType = (0, _react.useCallback)(selectedOptions => {
    setSelectedJobType(selectedOptions);
    setJobType(selectedOptions[0].id);
    onJobTypeChange === null || onJobTypeChange === void 0 ? void 0 : onJobTypeChange(selectedOptions[0].id === 'hosts' ? 'host' : 'pod');
  }, [onJobTypeChange]);
  const changeSortOptions = (0, _react.useCallback)(nextSortOptions => {
    handleSort(nextSortOptions);
  }, [handleSort]);
  (0, _react.useEffect)(() => {
    if (results) {
      results.forEach(r => {
        if (r.influencers.length > 100) {
          trackMetric({
            metric: 'metrics_ml_anomaly_detection_more_than_100_influencers'
          });
        }
      });
    }
  }, [results, trackMetric]);
  const onTableChange = criteria => {
    var _criteria$sort, _criteria$sort2;
    setSorting(criteria.sort);
    changeSortOptions({
      field: (criteria === null || criteria === void 0 ? void 0 : (_criteria$sort = criteria.sort) === null || _criteria$sort === void 0 ? void 0 : _criteria$sort.field) || 'startTime',
      direction: (criteria === null || criteria === void 0 ? void 0 : (_criteria$sort2 = criteria.sort) === null || _criteria$sort2 === void 0 ? void 0 : _criteria$sort2.direction) || 'desc'
    });
  };
  const columns = [{
    field: 'startTime',
    name: _i18n.i18n.translate('xpack.infra.ml.anomalyFlyout.columnTime', {
      defaultMessage: 'Time'
    }),
    width: '15%',
    sortable: true,
    textOnly: true,
    truncateText: true,
    render: startTime => /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedDate, {
      value: startTime,
      year: "numeric",
      month: "short",
      day: "2-digit",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 489,
        columnNumber: 9
      }
    })
  }, {
    field: 'jobId',
    name: _i18n.i18n.translate('xpack.infra.ml.anomalyFlyout.columnJob', {
      defaultMessage: 'Job'
    }),
    width: '25%',
    render: jobId => jobId,
    'data-test-subj': 'anomalyRow'
  }, {
    field: 'anomalyScore',
    name: _i18n.i18n.translate('xpack.infra.ml.anomalyFlyout.columnSeverit', {
      defaultMessage: 'Severity'
    }),
    width: '15%',
    sortable: true,
    render: anomalyScore => /*#__PURE__*/_react.default.createElement(_anomaly_severity_indicator.AnomalySeverityIndicator, {
      anomalyScore: anomalyScore,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 508,
        columnNumber: 41
      }
    })
  }, {
    field: 'typical',
    name: _i18n.i18n.translate('xpack.infra.ml.anomalyFlyout.columnSummary', {
      defaultMessage: 'Summary'
    }),
    width: '15%',
    textOnly: true,
    render: (typical, item) => /*#__PURE__*/_react.default.createElement(_annomaly_summary.AnomalySummary, {
      anomaly: item,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 517,
        columnNumber: 63
      }
    })
  }, {
    field: 'influencers',
    name: _i18n.i18n.translate('xpack.infra.ml.anomalyFlyout.columnInfluencerName', {
      defaultMessage: 'Node name'
    }),
    width: '20%',
    textOnly: true,
    truncateText: true,
    render: influencers => influencers.join(','),
    'data-test-subj': 'nodeNameRow'
  }, {
    name: _i18n.i18n.translate('xpack.infra.ml.anomalyFlyout.columnActionsName', {
      defaultMessage: 'Actions'
    }),
    width: '10%',
    actions: [{
      render: anomaly => {
        return /*#__PURE__*/_react.default.createElement(AnomalyActionMenu, {
          jobId: anomaly.jobId,
          type: anomaly.type,
          influencerField: anomaly.type === 'metrics_hosts' ? 'host.name' : 'kubernetes.pod.uid',
          disableShowInInventory: anomaly.influencers.length > 100,
          influencers: anomaly.influencers,
          startTime: anomaly.startTime,
          closeFlyout: closeFlyout,
          hostName: hostName,
          timeRange: timeRange,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 539,
            columnNumber: 15
          }
        });
      }
    }]
  }];
  const filteredColumns = hostName ? columns.filter(c => !('field' in c && c.field === 'influencers')) : columns;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 564,
      columnNumber: 5
    }
  }, !hideDatePicker && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 566,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSuperDatePicker, {
    start: timeRange.start,
    end: timeRange.end,
    showUpdateButton: false,
    onTimeChange: onTimeChange,
    width: "full",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 567,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 576,
      columnNumber: 7
    }
  }, !hostName && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 578,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 3,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 579,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldSearch, {
    "data-test-subj": "infraAnomaliesTableFieldSearch",
    fullWidth: true,
    placeholder: _i18n.i18n.translate('xpack.infra.ml.anomalyFlyout.searchPlaceholder', {
      defaultMessage: 'Search'
    }),
    value: search,
    onChange: onSearchChange,
    isClearable: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 580,
      columnNumber: 15
    }
  })), !hideSelectGroup && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 592,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    "aria-label": _i18n.i18n.translate('xpack.infra.anomaliesTable.selectgroupComboBox.ariaLabel', {
      defaultMessage: 'Select group'
    }),
    placeholder: _i18n.i18n.translate('xpack.infra.ml.anomalyFlyout.jobTypeSelect', {
      defaultMessage: 'Select group'
    }),
    singleSelection: {
      asPlainText: true
    },
    options: JOB_OPTIONS,
    selectedOptions: selectedJobType,
    onChange: changeJobType,
    fullWidth: true,
    isClearable: false,
    "data-test-subj": "anomaliesComboBoxType",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 593,
      columnNumber: 17
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 614,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    columns: filteredColumns,
    items: results,
    sorting: {
      sort: sorting
    },
    onChange: onTableChange,
    loading: isLoading,
    noItemsMessage: isLoading ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.infra.ml.anomalyFlyout.anomalyTable.loading",
      defaultMessage: "Loading anomalies",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 623,
        columnNumber: 15
      }
    }) : /*#__PURE__*/_react.default.createElement(NoAnomaliesFound, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 628,
        columnNumber: 15
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 615,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 633,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_pagination.PaginationControls, {
    fetchNextPage: fetchNextPage,
    fetchPreviousPage: fetchPreviousPage,
    page: page,
    isLoading: isLoading,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 634,
      columnNumber: 9
    }
  })));
};
exports.AnomaliesTable = AnomaliesTable;