"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useInventoryAlertPrefill = void 0;
var _react = require("react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const initialState = {
  nodeType: 'host',
  kuery: undefined,
  metric: {
    type: 'cpuV2'
  },
  customMetrics: [],
  schema: 'ecs',
  region: '',
  accountId: ''
};
function reducer(state, action) {
  switch (action.type) {
    case 'SET_PARTIAL':
      return {
        ...state,
        ...action.value
      };
    case 'RESET':
      return {
        ...initialState
      };
    default:
      return state;
  }
}
const useInventoryAlertPrefill = () => {
  const [state, dispatch] = (0, _react.useReducer)(reducer, initialState);
  return (0, _react.useMemo)(() => ({
    nodeType: state.nodeType,
    kuery: state.kuery,
    metric: state.metric,
    customMetrics: state.customMetrics,
    schema: state.schema,
    region: state.region,
    accountId: state.accountId,
    setPrefillState: value => dispatch({
      type: 'SET_PARTIAL',
      value
    }),
    reset: () => dispatch({
      type: 'RESET'
    })
  }), [state.nodeType, state.kuery, state.metric, state.customMetrics, state.schema, state.region, state.accountId]);
};
exports.useInventoryAlertPrefill = useInventoryAlertPrefill;