"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.responseToLangchainMessage = void 0;
var _messages = require("@langchain/core/messages");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const responseToLangchainMessage = response => {
  return new _messages.AIMessage({
    content: response.content,
    tool_calls: response.toolCalls.map(toolCall => {
      return {
        id: toolCall.toolCallId,
        name: toolCall.function.name,
        args: toolCall.function.arguments,
        type: 'tool_call'
      };
    })
  });
};
exports.responseToLangchainMessage = responseToLangchainMessage;