"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Introduction = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _content = require("./content");
var _constants = require("../../../../common/constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/home/public/application/components/tutorial/introduction.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function IntroductionUI({
  description,
  previewUrl,
  title,
  exportedFieldsUrl,
  iconType,
  isBeta = false,
  intl,
  notices,
  basePath,
  category
}) {
  let rightSideItems;
  if (previewUrl) {
    rightSideItems = [/*#__PURE__*/_react.default.createElement(_eui.EuiImage, {
      size: "l",
      allowFullScreen: true,
      fullScreenIconColor: "dark",
      alt: intl.formatMessage({
        id: 'home.tutorial.introduction.imageAltDescription',
        defaultMessage: 'screenshot of primary dashboard.'
      }),
      url: previewUrl,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 55,
        columnNumber: 7
      }
    })];
  }
  let exportedFields;
  if (exportedFieldsUrl) {
    exportedFields = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("br", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 71,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      href: exportedFieldsUrl,
      target: "_blank",
      rel: "noopener",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 72,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "home.tutorial.introduction.viewButtonLabel",
      defaultMessage: "View exported fields",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 73,
        columnNumber: 11
      }
    })));
  }
  let betaBadge;
  if (isBeta) {
    betaBadge = /*#__PURE__*/_react.default.createElement(_eui.EuiBetaBadge, {
      label: intl.formatMessage({
        id: 'home.tutorial.introduction.betaLabel',
        defaultMessage: 'Beta'
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 84,
        columnNumber: 7
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("div", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 94,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    iconType: "arrowLeft",
    size: "xs",
    flush: "left",
    href: basePath.prepend(`/app/integrations`),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "home.tutorial.introduction.browseAllIntegrationsButton",
    defaultMessage: "Browse all integrations",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 107,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiPageHeader, {
    iconType: iconType,
    pageTitle: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, title, betaBadge && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, "\xA0", betaBadge), category === _constants.TutorialsCategory.LOGGING || category === _constants.TutorialsCategory.METRICS ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, "\xA0", /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 123,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "home.tutorial.introduction.beatsBadgeLabel",
      defaultMessage: "Beats",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 124,
        columnNumber: 19
      }
    }))) : null),
    description: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_content.Content, {
      text: description,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 135,
        columnNumber: 13
      }
    }), exportedFields, notices),
    rightSideItems: rightSideItems,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 7
    }
  }));
}
const Introduction = exports.Introduction = (0, _i18nReact.injectI18n)(IntroductionUI);