"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AgentDiagnosticsTab = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _services = require("../../../../../../../../common/services");
var _hooks = require("../../../../../hooks");
var _agent_request_diagnostics_modal = require("../../../components/agent_request_diagnostics_modal");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/applications/fleet/sections/agents/agent_details_page/components/agent_diagnostics/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const AgentDiagnosticsTab = ({
  agent
}) => {
  const authz = (0, _hooks.useAuthz)();
  const {
    notifications
  } = (0, _hooks.useStartServices)();
  const {
    getAbsolutePath
  } = (0, _hooks.useLink)();
  const [isLoading, setIsLoading] = (0, _react.useState)(true);
  const [isShowingExpiredEntries, setIsShowingExpiredEntries] = (0, _react.useState)(false);
  const [visibleDiagnosticsEntries, setVisibleDiagnosticEntries] = (0, _react.useState)([]);
  const [allDiagnosticsEntries, setAllDiagnosticEntries] = (0, _react.useState)([]);
  const [prevDiagnosticsEntries, setPrevDiagnosticEntries] = (0, _react.useState)([]);
  const [loadInterval, setLoadInterval] = (0, _react.useState)(10000);
  const [isRequestDiagnosticsModalOpen, setIsRequestDiagnosticsModalOpen] = (0, _react.useState)(false);
  const loadData = (0, _react.useCallback)(async () => {
    try {
      const uploadsResponse = await (0, _hooks.sendGetAgentUploads)(agent.id);
      const error = uploadsResponse.error;
      if (error) {
        throw error;
      }
      if (!uploadsResponse.data) {
        throw new Error('No data');
      }
      const entries = uploadsResponse.data.items;
      setAllDiagnosticEntries(entries);
      setIsLoading(false);

      // query faster if an action is in progress, for quicker feedback
      if (entries.some(entry => entry.status === 'IN_PROGRESS' || entry.status === 'AWAITING_UPLOAD')) {
        setLoadInterval(3000);
      } else {
        setLoadInterval(10000);
      }
    } catch (err) {
      notifications.toasts.addError(err, {
        title: _i18n.i18n.translate('xpack.fleet.requestDiagnostics.errorLoadingUploadsNotificationTitle', {
          defaultMessage: 'Error loading diagnostics uploads'
        })
      });
    }
  }, [agent.id, notifications.toasts, setLoadInterval]);
  const deleteFile = fileId => {
    (0, _hooks.sendDeleteAgentUpload)(fileId).then(({
      data,
      error
    }) => {
      if (error || (data === null || data === void 0 ? void 0 : data.deleted) === false) {
        notifications.toasts.addError(error || new Error('Request returned `deleted: false`'), {
          title: _i18n.i18n.translate('xpack.fleet.requestDiagnostics.errorDeletingUploadNotificationTitle', {
            defaultMessage: 'Error deleting diagnostics file'
          })
        });
      } else {
        notifications.toasts.addSuccess({
          title: _i18n.i18n.translate('xpack.fleet.requestDiagnostics.successDeletingUploadNotificationTitle', {
            defaultMessage: 'Diagnostics file deleted'
          })
        });
      }
      loadData();
    });
  };
  (0, _react.useEffect)(() => {
    loadData();
    const interval = setInterval(async () => {
      loadData();
    }, loadInterval);
    const cleanup = () => {
      if (interval) {
        clearInterval(interval);
      }
    };
    return cleanup;
  }, [loadData, loadInterval]);
  (0, _react.useEffect)(() => {
    setPrevDiagnosticEntries(allDiagnosticsEntries);
    if (prevDiagnosticsEntries.length > 0) {
      allDiagnosticsEntries.filter(newEntry => {
        const oldEntry = prevDiagnosticsEntries.find(entry => entry.id === newEntry.id);
        return newEntry.status === 'READY' && (!oldEntry || (oldEntry === null || oldEntry === void 0 ? void 0 : oldEntry.status) !== 'READY');
      }).forEach(entry => {
        notifications.toasts.addSuccess({
          title: _i18n.i18n.translate('xpack.fleet.requestDiagnostics.readyNotificationTitle', {
            defaultMessage: 'Agent diagnostics {name} ready',
            values: {
              name: entry.name
            }
          })
        }, {
          toastLifeTimeMs: 5000
        });
      });
    }
  }, [prevDiagnosticsEntries, allDiagnosticsEntries, notifications.toasts]);
  (0, _react.useEffect)(() => {
    if (isShowingExpiredEntries) {
      setVisibleDiagnosticEntries(allDiagnosticsEntries);
    } else {
      setVisibleDiagnosticEntries(allDiagnosticsEntries.filter(entry => entry.status !== 'EXPIRED'));
    }
  }, [allDiagnosticsEntries, isShowingExpiredEntries]);
  const columns = [{
    field: 'id',
    name: _i18n.i18n.translate('xpack.fleet.requestDiagnostics.tableColumns.fileLabelText', {
      defaultMessage: 'File'
    }),
    render: id => {
      const currentItem = allDiagnosticsEntries.find(item => item.id === id);
      return (currentItem === null || currentItem === void 0 ? void 0 : currentItem.status) === 'READY' ? /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: getAbsolutePath(currentItem === null || currentItem === void 0 ? void 0 : currentItem.filePath),
        download: true,
        target: "_blank",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 180,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        type: "download",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 181,
          columnNumber: 13
        }
      }), " \xA0 ", currentItem === null || currentItem === void 0 ? void 0 : currentItem.name) : (currentItem === null || currentItem === void 0 ? void 0 : currentItem.status) === 'IN_PROGRESS' || (currentItem === null || currentItem === void 0 ? void 0 : currentItem.status) === 'AWAITING_UPLOAD' ? /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        color: "subdued",
        disabled: true,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 184,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 185,
          columnNumber: 13
        }
      }), " \xA0", /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.requestDiagnostics.generatingText",
        defaultMessage: "Generating diagnostics file...",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 186,
          columnNumber: 13
        }
      })) : /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        color: "subdued",
        disabled: true,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 192,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        gutterSize: "s",
        direction: "row",
        alignItems: "center",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 193,
          columnNumber: 13
        }
      }, currentItem !== null && currentItem !== void 0 && currentItem.error ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 195,
          columnNumber: 17
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
        content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.fleet.requestDiagnostics.errorGeneratingFileMessage",
          defaultMessage: "Error generating file: {reason}",
          values: {
            reason: currentItem.error
          },
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 198,
            columnNumber: 23
          }
        }),
        type: "warning",
        color: "danger",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 196,
          columnNumber: 19
        }
      })) : currentItem !== null && currentItem !== void 0 && currentItem.status ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 209,
          columnNumber: 17
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
        content: currentItem.status,
        type: "warning",
        color: "danger",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 210,
          columnNumber: 19
        }
      })) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 213,
          columnNumber: 15
        }
      }, currentItem === null || currentItem === void 0 ? void 0 : currentItem.name)));
    }
  }, {
    field: 'id',
    name: _i18n.i18n.translate('xpack.fleet.requestDiagnostics.tableColumns.dateLabelText', {
      defaultMessage: 'Date'
    }),
    dataType: 'date',
    render: id => {
      const currentItem = allDiagnosticsEntries.find(item => item.id === id);
      return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s",
        color: (currentItem === null || currentItem === void 0 ? void 0 : currentItem.status) === 'READY' ? 'default' : 'subdued',
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 228,
          columnNumber: 11
        }
      }, (0, _eui.formatDate)(currentItem === null || currentItem === void 0 ? void 0 : currentItem.createTime, 'lll'));
    }
  }, ...(authz.fleet.allAgents ? [{
    name: _i18n.i18n.translate('xpack.fleet.requestDiagnostics.tableColumns.actionsLabelText', {
      defaultMessage: 'Actions'
    }),
    width: '70px',
    actions: [{
      type: 'icon',
      icon: 'trash',
      color: 'danger',
      name: _i18n.i18n.translate('xpack.fleet.requestDiagnostics.tableColumns.deleteButtonText', {
        defaultMessage: 'Delete'
      }),
      available: item => item.status === 'READY',
      description: _i18n.i18n.translate('xpack.fleet.requestDiagnostics.tableColumns.deleteButtonDesc', {
        defaultMessage: 'Delete diagnostics file'
      }),
      onClick: item => {
        deleteFile(item.id);
      }
    }]
  }] : [])];
  const requestDiagnosticsButton = /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    size: "s",
    onClick: () => {
      setIsRequestDiagnosticsModalOpen(true);
    },
    disabled: !(0, _services.isAgentRequestDiagnosticsSupported)(agent) || !authz.fleet.readAgents,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 270,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.requestDiagnostics.diagnosticsOneButton",
    defaultMessage: "Request diagnostics .zip",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 278,
      columnNumber: 7
    }
  }));
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isRequestDiagnosticsModalOpen && /*#__PURE__*/_react.default.createElement(_eui.EuiPortal, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 288,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_agent_request_diagnostics_modal.AgentRequestDiagnosticsModal, {
    agents: [agent],
    agentCount: 1,
    onClose: () => {
      setIsRequestDiagnosticsModalOpen(false);
      loadData();
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 289,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 299,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 300,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.requestDiagnostics.calloutText",
    defaultMessage: "Consider changing the log level to debug before requesting a diagnostic. Diagnostics files are stored in Elasticsearch, and as such can incur storage costs. By default, files are deleted periodically through an ILM policy.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 301,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 307,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "m",
    alignItems: "center",
    justifyContent: "spaceBetween",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 308,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 314,
      columnNumber: 9
    }
  }, (0, _services.isAgentRequestDiagnosticsSupported)(agent) ? requestDiagnosticsButton : /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.requestDiagnostics.notSupportedTooltip",
      defaultMessage: "Requesting agent diagnostics is not supported for agents before version {version}.",
      values: {
        version: _services.MINIMUM_DIAGNOSTICS_AGENT_VERSION
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 320,
        columnNumber: 17
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 318,
      columnNumber: 13
    }
  }, requestDiagnosticsButton)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 331,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.requestDiagnostics.showExpiredFilesLabel",
      defaultMessage: "Show expired file requests",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 334,
        columnNumber: 15
      }
    }),
    checked: isShowingExpiredEntries,
    onChange: e => setIsShowingExpiredEntries(e.target.checked),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 332,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 345,
      columnNumber: 7
    }
  }), isLoading ? /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
    lines: 3,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 347,
      columnNumber: 9
    }
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    items: visibleDiagnosticsEntries,
    columns: columns,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 349,
      columnNumber: 9
    }
  }));
};
exports.AgentDiagnosticsTab = AgentDiagnosticsTab;