"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAgentPoliciesOptions = useAgentPoliciesOptions;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _common = require("../../../../../../../../../common");
var _constants = require("../../../../../../../../../common/constants");
var _services = require("../../../../../../../../../common/services");
var _hooks = require("../../../../../../hooks");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/applications/fleet/sections/agent_policy/create_package_policy_page/components/steps/components/agent_policy_options.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function useAgentPoliciesOptions(packageInfo) {
  // Fetch agent policies info
  const {
    data: agentPoliciesData,
    error: agentPoliciesError,
    isLoading: isAgentPoliciesLoading
  } = (0, _hooks.useGetAgentPolicies)({
    page: 1,
    perPage: _common.SO_SEARCH_LIMIT,
    sortField: 'name',
    sortOrder: 'asc',
    noAgentCount: true,
    // agentPolicy.agents will always be 0
    full: false // package_policies will always be empty
  });
  const agentPolicies = (0, _react.useMemo)(() => (agentPoliciesData === null || agentPoliciesData === void 0 ? void 0 : agentPoliciesData.items.filter(policy => !policy.is_managed)) || [], [agentPoliciesData === null || agentPoliciesData === void 0 ? void 0 : agentPoliciesData.items]);
  const {
    data: outputsData,
    isLoading: isOutputLoading
  } = (0, _hooks.useGetOutputs)();

  // get all package policies with apm integration or the current integration
  const {
    data: packagePoliciesForThisPackage,
    isLoading: isLoadingPackagePolicies
  } = (0, _hooks.useGetPackagePolicies)({
    page: 1,
    perPage: _common.SO_SEARCH_LIMIT,
    kuery: `${_common.PACKAGE_POLICY_SAVED_OBJECT_TYPE}.package.name: ${packageInfo === null || packageInfo === void 0 ? void 0 : packageInfo.name}`
  });
  const packagePoliciesForThisPackageByAgentPolicyId = (0, _react.useMemo)(() => packagePoliciesForThisPackage === null || packagePoliciesForThisPackage === void 0 ? void 0 : packagePoliciesForThisPackage.items.reduce((acc, packagePolicy) => {
    packagePolicy.policy_ids.forEach(policyId => {
      acc[policyId] = true;
    });
    return acc;
  }, {}), [packagePoliciesForThisPackage === null || packagePoliciesForThisPackage === void 0 ? void 0 : packagePoliciesForThisPackage.items]);
  const {
    getDataOutputForPolicy
  } = (0, _react.useMemo)(() => {
    var _outputsData$items, _outputsData$items2;
    const defaultOutput = ((_outputsData$items = outputsData === null || outputsData === void 0 ? void 0 : outputsData.items) !== null && _outputsData$items !== void 0 ? _outputsData$items : []).find(output => output.is_default);
    const outputsById = ((_outputsData$items2 = outputsData === null || outputsData === void 0 ? void 0 : outputsData.items) !== null && _outputsData$items2 !== void 0 ? _outputsData$items2 : []).reduce((acc, output) => {
      acc[output.id] = output;
      return acc;
    }, {});
    return {
      getDataOutputForPolicy: policy => {
        return policy.data_output_id ? outputsById[policy.data_output_id] : defaultOutput;
      }
    };
  }, [outputsData]);
  const agentPolicyOptions = (0, _react.useMemo)(() => packageInfo ? agentPolicies.map(policy => {
    var _getDataOutputForPoli;
    const isLimitedPackageAlreadyInPolicy = (0, _services.isPackageLimited)(packageInfo) && (packagePoliciesForThisPackageByAgentPolicyId === null || packagePoliciesForThisPackageByAgentPolicyId === void 0 ? void 0 : packagePoliciesForThisPackageByAgentPolicyId[policy.id]);
    const isAPMPackageAndDataOutputIsLogstash = (packageInfo === null || packageInfo === void 0 ? void 0 : packageInfo.name) === _common.FLEET_APM_PACKAGE && ((_getDataOutputForPoli = getDataOutputForPolicy(policy)) === null || _getDataOutputForPoli === void 0 ? void 0 : _getDataOutputForPoli.type) === _constants.outputType.Logstash;
    return {
      inputDisplay: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 99,
          columnNumber: 19
        }
      }, policy.name), isAPMPackageAndDataOutputIsLogstash && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "xs",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 102,
          columnNumber: 23
        }
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 103,
          columnNumber: 23
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.createPackagePolicy.StepSelectPolicy.agentPolicyDisabledAPMLogstashOuputText",
        defaultMessage: "Logstash output for integrations is not supported with APM",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 104,
          columnNumber: 25
        }
      })))),
      value: policy.id,
      disabled: isLimitedPackageAlreadyInPolicy || isAPMPackageAndDataOutputIsLogstash,
      'data-test-subj': 'agentPolicyItem'
    };
  }) : [], [packageInfo, agentPolicies, packagePoliciesForThisPackageByAgentPolicyId, getDataOutputForPolicy]);
  const agentPolicyMultiOptions = (0, _react.useMemo)(() => packageInfo && !isOutputLoading && !isAgentPoliciesLoading && !isLoadingPackagePolicies ? agentPolicies.filter(policy => policy.supports_agentless !== true).map(policy => {
    var _getDataOutputForPoli2;
    const isLimitedPackageAlreadyInPolicy = (0, _services.isPackageLimited)(packageInfo) && (packagePoliciesForThisPackageByAgentPolicyId === null || packagePoliciesForThisPackageByAgentPolicyId === void 0 ? void 0 : packagePoliciesForThisPackageByAgentPolicyId[policy.id]);
    const isAPMPackageAndDataOutputIsLogstash = (packageInfo === null || packageInfo === void 0 ? void 0 : packageInfo.name) === _common.FLEET_APM_PACKAGE && ((_getDataOutputForPoli2 = getDataOutputForPolicy(policy)) === null || _getDataOutputForPoli2 === void 0 ? void 0 : _getDataOutputForPoli2.type) === _constants.outputType.Logstash;
    return {
      append: isAPMPackageAndDataOutputIsLogstash ? /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
        content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.fleet.createPackagePolicy.StepSelectPolicy.agentPolicyDisabledAPMLogstashOuputText",
          defaultMessage: "Logstash output for integrations is not supported with APM",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 145,
            columnNumber: 23
          }
        }),
        type: "warningFilled",
        size: "s",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 143,
          columnNumber: 19
        }
      }) : null,
      key: policy.id,
      label: policy.name,
      disabled: isLimitedPackageAlreadyInPolicy || isAPMPackageAndDataOutputIsLogstash,
      'data-test-subj': 'agentPolicyMultiItem'
    };
  }) : [], [packageInfo, agentPolicies, packagePoliciesForThisPackageByAgentPolicyId, getDataOutputForPolicy, isOutputLoading, isAgentPoliciesLoading, isLoadingPackagePolicies]);
  return {
    agentPoliciesError,
    isLoading: isOutputLoading || isAgentPoliciesLoading || isLoadingPackagePolicies,
    agentPolicyOptions,
    agentPolicies,
    agentPolicyMultiOptions
  };
}