"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
var _exportNames = {
  AgentStatusKueryHelper: true,
  packageToPackagePolicyInputs: true,
  packageToPackagePolicy: true,
  getStreamsForInputType: true,
  getRegistryStreamWithDataStreamForInputType: true,
  varsReducer: true,
  fullAgentPolicyToYaml: true,
  isPackageLimited: true,
  doesAgentPolicyAlreadyIncludePackage: true,
  isValidDataset: true,
  isValidNamespace: true,
  INVALID_NAMESPACE_CHARACTERS: true,
  isDiffPathProtocol: true,
  LicenseService: true,
  isAgentRequestDiagnosticsSupported: true,
  MINIMUM_DIAGNOSTICS_AGENT_VERSION: true,
  isAgentMigrationSupported: true,
  MINIMUM_MIGRATE_AGENT_VERSION: true,
  isInputOnlyPolicyTemplate: true,
  isIntegrationPolicyTemplate: true,
  getNormalizedInputs: true,
  getNormalizedDataStreams: true,
  filterPolicyTemplatesTiles: true,
  doesPackageHaveIntegrations: true,
  validatePackagePolicy: true,
  validatePackagePolicyConfig: true,
  validationHasErrors: true,
  countValidationErrors: true,
  normalizeHostsForAgents: true,
  splitPkgKey: true,
  getMaxPackageName: true,
  getMinVersion: true,
  getMaxVersion: true,
  getPipelineNameForDatastream: true,
  getCustomPipelineNameForDatastream: true,
  getRegistryDataStreamAssetBaseName: true,
  getComponentTemplateNameForDatastream: true,
  getPackageReleaseLabel: true,
  isPackagePrerelease: true,
  mapPackageReleaseToIntegrationCardRelease: true,
  getAllowedOutputTypesForAgentPolicy: true,
  agentStatusesToSummary: true,
  policyHasFleetServer: true,
  policyHasAPMIntegration: true,
  policyHasEndpointSecurity: true,
  policyHasSyntheticsIntegration: true,
  getInheritedNamespace: true,
  generateNewAgentPolicyWithDefaults: true,
  agentPolicyWithoutPaidFeatures: true,
  isAgentPolicyValidForLicense: true,
  unsetAgentPolicyAccordingToLicenseLevel: true,
  getFleetServerVersionMessage: true,
  isAgentVersionLessThanFleetServer: true,
  removeSOAttributes: true,
  getSortConfig: true,
  checkTargetVersionsValidity: true
};
exports.AgentStatusKueryHelper = void 0;
Object.defineProperty(exports, "INVALID_NAMESPACE_CHARACTERS", {
  enumerable: true,
  get: function () {
    return _is_valid_namespace.INVALID_NAMESPACE_CHARACTERS;
  }
});
Object.defineProperty(exports, "LicenseService", {
  enumerable: true,
  get: function () {
    return _license.LicenseService;
  }
});
Object.defineProperty(exports, "MINIMUM_DIAGNOSTICS_AGENT_VERSION", {
  enumerable: true,
  get: function () {
    return _is_agent_request_diagnostics_supported.MINIMUM_DIAGNOSTICS_AGENT_VERSION;
  }
});
Object.defineProperty(exports, "MINIMUM_MIGRATE_AGENT_VERSION", {
  enumerable: true,
  get: function () {
    return _is_agent_migrate_supported.MINIMUM_MIGRATE_AGENT_VERSION;
  }
});
Object.defineProperty(exports, "agentPolicyWithoutPaidFeatures", {
  enumerable: true,
  get: function () {
    return _generate_new_agent_policy.agentPolicyWithoutPaidFeatures;
  }
});
Object.defineProperty(exports, "agentStatusesToSummary", {
  enumerable: true,
  get: function () {
    return _agent_statuses_to_summary.agentStatusesToSummary;
  }
});
Object.defineProperty(exports, "checkTargetVersionsValidity", {
  enumerable: true,
  get: function () {
    return _agent_utils.checkTargetVersionsValidity;
  }
});
Object.defineProperty(exports, "countValidationErrors", {
  enumerable: true,
  get: function () {
    return _validate_package_policy.countValidationErrors;
  }
});
Object.defineProperty(exports, "doesAgentPolicyAlreadyIncludePackage", {
  enumerable: true,
  get: function () {
    return _limited_package.doesAgentPolicyAlreadyIncludePackage;
  }
});
Object.defineProperty(exports, "doesPackageHaveIntegrations", {
  enumerable: true,
  get: function () {
    return _packages_with_integrations.doesPackageHaveIntegrations;
  }
});
Object.defineProperty(exports, "filterPolicyTemplatesTiles", {
  enumerable: true,
  get: function () {
    return _policy_template.filterPolicyTemplatesTiles;
  }
});
Object.defineProperty(exports, "fullAgentPolicyToYaml", {
  enumerable: true,
  get: function () {
    return _full_agent_policy_to_yaml.fullAgentPolicyToYaml;
  }
});
Object.defineProperty(exports, "generateNewAgentPolicyWithDefaults", {
  enumerable: true,
  get: function () {
    return _generate_new_agent_policy.generateNewAgentPolicyWithDefaults;
  }
});
Object.defineProperty(exports, "getAllowedOutputTypesForAgentPolicy", {
  enumerable: true,
  get: function () {
    return _output_helpers.getAllowedOutputTypesForAgentPolicy;
  }
});
Object.defineProperty(exports, "getComponentTemplateNameForDatastream", {
  enumerable: true,
  get: function () {
    return _datastream_es_name.getComponentTemplateNameForDatastream;
  }
});
Object.defineProperty(exports, "getCustomPipelineNameForDatastream", {
  enumerable: true,
  get: function () {
    return _datastream_es_name.getCustomPipelineNameForDatastream;
  }
});
Object.defineProperty(exports, "getFleetServerVersionMessage", {
  enumerable: true,
  get: function () {
    return _check_fleet_server_versions.getFleetServerVersionMessage;
  }
});
Object.defineProperty(exports, "getInheritedNamespace", {
  enumerable: true,
  get: function () {
    return _agent_policies_helpers.getInheritedNamespace;
  }
});
Object.defineProperty(exports, "getMaxPackageName", {
  enumerable: true,
  get: function () {
    return _max_package_name.getMaxPackageName;
  }
});
Object.defineProperty(exports, "getMaxVersion", {
  enumerable: true,
  get: function () {
    return _get_min_max_version.getMaxVersion;
  }
});
Object.defineProperty(exports, "getMinVersion", {
  enumerable: true,
  get: function () {
    return _get_min_max_version.getMinVersion;
  }
});
Object.defineProperty(exports, "getNormalizedDataStreams", {
  enumerable: true,
  get: function () {
    return _policy_template.getNormalizedDataStreams;
  }
});
Object.defineProperty(exports, "getNormalizedInputs", {
  enumerable: true,
  get: function () {
    return _policy_template.getNormalizedInputs;
  }
});
Object.defineProperty(exports, "getPackageReleaseLabel", {
  enumerable: true,
  get: function () {
    return _package_prerelease.getPackageReleaseLabel;
  }
});
Object.defineProperty(exports, "getPipelineNameForDatastream", {
  enumerable: true,
  get: function () {
    return _datastream_es_name.getPipelineNameForDatastream;
  }
});
Object.defineProperty(exports, "getRegistryDataStreamAssetBaseName", {
  enumerable: true,
  get: function () {
    return _datastream_es_name.getRegistryDataStreamAssetBaseName;
  }
});
Object.defineProperty(exports, "getRegistryStreamWithDataStreamForInputType", {
  enumerable: true,
  get: function () {
    return _package_to_package_policy.getRegistryStreamWithDataStreamForInputType;
  }
});
Object.defineProperty(exports, "getSortConfig", {
  enumerable: true,
  get: function () {
    return _agent_utils.getSortConfig;
  }
});
Object.defineProperty(exports, "getStreamsForInputType", {
  enumerable: true,
  get: function () {
    return _package_to_package_policy.getStreamsForInputType;
  }
});
Object.defineProperty(exports, "isAgentMigrationSupported", {
  enumerable: true,
  get: function () {
    return _is_agent_migrate_supported.isAgentMigrationSupported;
  }
});
Object.defineProperty(exports, "isAgentPolicyValidForLicense", {
  enumerable: true,
  get: function () {
    return _agent_policy_config.isAgentPolicyValidForLicense;
  }
});
Object.defineProperty(exports, "isAgentRequestDiagnosticsSupported", {
  enumerable: true,
  get: function () {
    return _is_agent_request_diagnostics_supported.isAgentRequestDiagnosticsSupported;
  }
});
Object.defineProperty(exports, "isAgentVersionLessThanFleetServer", {
  enumerable: true,
  get: function () {
    return _check_fleet_server_versions.isAgentVersionLessThanFleetServer;
  }
});
Object.defineProperty(exports, "isDiffPathProtocol", {
  enumerable: true,
  get: function () {
    return _is_diff_path_protocol.isDiffPathProtocol;
  }
});
Object.defineProperty(exports, "isInputOnlyPolicyTemplate", {
  enumerable: true,
  get: function () {
    return _policy_template.isInputOnlyPolicyTemplate;
  }
});
Object.defineProperty(exports, "isIntegrationPolicyTemplate", {
  enumerable: true,
  get: function () {
    return _policy_template.isIntegrationPolicyTemplate;
  }
});
Object.defineProperty(exports, "isPackageLimited", {
  enumerable: true,
  get: function () {
    return _limited_package.isPackageLimited;
  }
});
Object.defineProperty(exports, "isPackagePrerelease", {
  enumerable: true,
  get: function () {
    return _package_prerelease.isPackagePrerelease;
  }
});
Object.defineProperty(exports, "isValidDataset", {
  enumerable: true,
  get: function () {
    return _is_valid_namespace.isValidDataset;
  }
});
Object.defineProperty(exports, "isValidNamespace", {
  enumerable: true,
  get: function () {
    return _is_valid_namespace.isValidNamespace;
  }
});
Object.defineProperty(exports, "mapPackageReleaseToIntegrationCardRelease", {
  enumerable: true,
  get: function () {
    return _package_prerelease.mapPackageReleaseToIntegrationCardRelease;
  }
});
Object.defineProperty(exports, "normalizeHostsForAgents", {
  enumerable: true,
  get: function () {
    return _hosts_utils.normalizeHostsForAgents;
  }
});
Object.defineProperty(exports, "packageToPackagePolicy", {
  enumerable: true,
  get: function () {
    return _package_to_package_policy.packageToPackagePolicy;
  }
});
Object.defineProperty(exports, "packageToPackagePolicyInputs", {
  enumerable: true,
  get: function () {
    return _package_to_package_policy.packageToPackagePolicyInputs;
  }
});
Object.defineProperty(exports, "policyHasAPMIntegration", {
  enumerable: true,
  get: function () {
    return _agent_policies_helpers.policyHasAPMIntegration;
  }
});
Object.defineProperty(exports, "policyHasEndpointSecurity", {
  enumerable: true,
  get: function () {
    return _agent_policies_helpers.policyHasEndpointSecurity;
  }
});
Object.defineProperty(exports, "policyHasFleetServer", {
  enumerable: true,
  get: function () {
    return _agent_policies_helpers.policyHasFleetServer;
  }
});
Object.defineProperty(exports, "policyHasSyntheticsIntegration", {
  enumerable: true,
  get: function () {
    return _agent_policies_helpers.policyHasSyntheticsIntegration;
  }
});
Object.defineProperty(exports, "removeSOAttributes", {
  enumerable: true,
  get: function () {
    return _agent_utils.removeSOAttributes;
  }
});
Object.defineProperty(exports, "splitPkgKey", {
  enumerable: true,
  get: function () {
    return _split_pkg_key.splitPkgKey;
  }
});
Object.defineProperty(exports, "unsetAgentPolicyAccordingToLicenseLevel", {
  enumerable: true,
  get: function () {
    return _agent_policy_config.unsetAgentPolicyAccordingToLicenseLevel;
  }
});
Object.defineProperty(exports, "validatePackagePolicy", {
  enumerable: true,
  get: function () {
    return _validate_package_policy.validatePackagePolicy;
  }
});
Object.defineProperty(exports, "validatePackagePolicyConfig", {
  enumerable: true,
  get: function () {
    return _validate_package_policy.validatePackagePolicyConfig;
  }
});
Object.defineProperty(exports, "validationHasErrors", {
  enumerable: true,
  get: function () {
    return _validate_package_policy.validationHasErrors;
  }
});
Object.defineProperty(exports, "varsReducer", {
  enumerable: true,
  get: function () {
    return _package_to_package_policy.varsReducer;
  }
});
var _routes = require("./routes");
Object.keys(_routes).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _routes[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _routes[key];
    }
  });
});
var _AgentStatusKueryHelper = _interopRequireWildcard(require("./agent_status"));
exports.AgentStatusKueryHelper = _AgentStatusKueryHelper;
var _package_helpers = require("./package_helpers");
Object.keys(_package_helpers).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _package_helpers[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _package_helpers[key];
    }
  });
});
var _package_to_package_policy = require("./package_to_package_policy");
var _full_agent_policy_to_yaml = require("./full_agent_policy_to_yaml");
var _limited_package = require("./limited_package");
var _is_valid_namespace = require("./is_valid_namespace");
var _is_diff_path_protocol = require("./is_diff_path_protocol");
var _license = require("./license");
var _is_agent_upgradeable = require("./is_agent_upgradeable");
Object.keys(_is_agent_upgradeable).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _is_agent_upgradeable[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _is_agent_upgradeable[key];
    }
  });
});
var _is_agent_request_diagnostics_supported = require("./is_agent_request_diagnostics_supported");
var _is_agent_migrate_supported = require("./is_agent_migrate_supported");
var _policy_template = require("./policy_template");
var _packages_with_integrations = require("./packages_with_integrations");
var _validate_package_policy = require("./validate_package_policy");
var _hosts_utils = require("./hosts_utils");
var _split_pkg_key = require("./split_pkg_key");
var _max_package_name = require("./max_package_name");
var _get_min_max_version = require("./get_min_max_version");
var _datastream_es_name = require("./datastream_es_name");
var _file_storage = require("./file_storage");
Object.keys(_file_storage).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _file_storage[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _file_storage[key];
    }
  });
});
var _package_prerelease = require("./package_prerelease");
var _output_helpers = require("./output_helpers");
var _agent_statuses_to_summary = require("./agent_statuses_to_summary");
var _agent_policies_helpers = require("./agent_policies_helpers");
var _generate_new_agent_policy = require("./generate_new_agent_policy");
var _agent_policy_config = require("./agent_policy_config");
var _check_fleet_server_versions = require("./check_fleet_server_versions");
var _agent_utils = require("./agent_utils");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }