"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GeoFilePicker = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _constants = require("@kbn/file-upload-common/src/constants");
var _geo = require("../../importer/geo");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/file_upload/public/components/geo_upload_form/geo_file_picker.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
class GeoFilePicker extends _react.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "_isMounted", false);
    (0, _defineProperty2.default)(this, "state", {
      defaultIndexName: null,
      error: null,
      isLoadingPreview: false,
      importer: null,
      previewSummary: null
    });
    (0, _defineProperty2.default)(this, "_onFileSelect", files => {
      this.props.onClear();
      this.setState({
        defaultIndexName: null,
        error: null,
        isLoadingPreview: false,
        importer: null,
        previewSummary: null
      });
      if (files && files.length) {
        const file = files[0];
        try {
          const importer = (0, _geo.geoImporterFactory)(file);
          this.setState({
            defaultIndexName: file.name.split('.')[0].toLowerCase(),
            importer
          }, this._loadFilePreview);
        } catch (error) {
          this.setState({
            error: error.message
          });
        }
      }
    });
    (0, _defineProperty2.default)(this, "_loadFilePreview", async () => {
      if (!this.state.importer || !this.state.importer.canPreview()) {
        return;
      }
      this.setState({
        isLoadingPreview: true
      });
      let previewError = null;
      let preview = null;
      try {
        preview = await this.state.importer.previewFile(10000, _constants.MB * 3);
        if (preview.features.length === 0) {
          previewError = _i18n.i18n.translate('xpack.fileUpload.geoFilePicker.noFeaturesDetected', {
            defaultMessage: 'No features found in selected file.'
          });
        }
      } catch (error) {
        previewError = error.message;
      }
      if (!this._isMounted) {
        return;
      }
      this.setState({
        error: previewError,
        isLoadingPreview: false,
        previewSummary: !previewError && preview ? _i18n.i18n.translate('xpack.fileUpload.geoFilePicker.previewSummary', {
          defaultMessage: 'Previewing {numFeatures} features, {previewCoverage}% of file.',
          values: {
            numFeatures: preview.features.length,
            previewCoverage: preview.previewCoverage
          }
        }) : null
      });
      if (preview) {
        this.props.onSelect({
          ...preview,
          importer: this.state.importer,
          indexName: this.state.defaultIndexName ? this.state.defaultIndexName : 'features'
        });
      }
    });
  }
  async componentDidMount() {
    this._isMounted = true;
  }
  componentWillUnmount() {
    this._isMounted = false;
  }
  _renderHelpText() {
    return this.state.previewSummary !== null ? this.state.previewSummary : /*#__PURE__*/_react.default.createElement("span", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 132,
        columnNumber: 7
      }
    }, _i18n.i18n.translate('xpack.fileUpload.geoFilePicker.acceptedFormats', {
      defaultMessage: 'Formats accepted: {fileTypes}',
      values: {
        fileTypes: _geo.GEO_FILE_TYPES.join(', ')
      }
    }));
  }
  _renderImporterEditor() {
    return this.state.importer ? this.state.importer.renderEditor(this._loadFilePreview) : null;
  }
  render() {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      isInvalid: !!this.state.error,
      error: !!this.state.error ? [this.state.error] : [],
      helpText: this._renderHelpText(),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 148,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFilePicker, {
      isInvalid: !!this.state.error,
      initialPromptText: _i18n.i18n.translate('xpack.fileUpload.geoFilePicker.filePicker', {
        defaultMessage: 'Select or drag and drop a file'
      }),
      onChange: this._onFileSelect,
      accept: _geo.GEO_FILE_TYPES.join(','),
      isLoading: this.state.isLoadingPreview,
      "data-test-subj": "geoFilePicker",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 153,
        columnNumber: 11
      }
    })), this._renderImporterEditor());
  }
}
exports.GeoFilePicker = GeoFilePicker;