"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TikaReader = void 0;
var _base64Js = require("base64-js");
var _file_reader_base = require("./file_reader_base");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class TikaReader extends _file_reader_base.FileReaderBase {
  read(data) {
    let docArray = [];
    const pdfBase64 = (0, _base64Js.fromByteArray)(new Uint8Array(data));
    const {
      success,
      docs
    } = this._createDocs(pdfBase64);
    if (success) {
      docArray = docArray.concat(docs);
    } else {
      throw new Error(`Failed to create docs from TikaReader`);
    }
    return docArray;
  }
  _createDocs(base64String) {
    const remainder = 0;
    try {
      const docs = [{
        data: base64String
      }];
      return {
        success: true,
        docs,
        remainder
      };
    } catch (error) {
      return {
        success: false,
        docs: [],
        remainder,
        error
      };
    }
  }
}
exports.TikaReader = TikaReader;