"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.sampleAnnotationLayer = exports.mockPaletteOutput = exports.createSampleDatatableWithRows = exports.createArgsWithLayers = void 0;
exports.sampleArgs = sampleArgs;
exports.sampleReferenceLineLayer = exports.sampleLayer = exports.sampleExtendedLayer = void 0;
var _charts = require("@elastic/charts");
var _constants = require("../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const mockPaletteOutput = exports.mockPaletteOutput = {
  type: 'palette',
  name: 'mock',
  params: {}
};
const createSampleDatatableWithRows = rows => ({
  type: 'datatable',
  columns: [{
    id: 'a',
    name: 'a',
    meta: {
      type: 'number',
      params: {
        id: 'number',
        params: {
          pattern: '0,0.000'
        }
      }
    }
  }, {
    id: 'b',
    name: 'b',
    meta: {
      type: 'number',
      params: {
        id: 'number',
        params: {
          pattern: '000,0'
        }
      }
    }
  }, {
    id: 'c',
    name: 'c',
    meta: {
      type: 'date',
      field: 'order_date',
      sourceParams: {
        type: 'date-histogram',
        params: {
          interval: 'auto'
        }
      },
      params: {
        id: 'string'
      }
    }
  }, {
    id: 'd',
    name: 'ColD',
    meta: {
      type: 'string'
    }
  }],
  rows
});
exports.createSampleDatatableWithRows = createSampleDatatableWithRows;
const sampleAnnotationLayer = exports.sampleAnnotationLayer = {
  layerId: 'first',
  type: 'annotationLayer',
  layerType: _constants.LayerTypes.ANNOTATIONS,
  annotations: [{
    type: 'manual_point_event_annotation',
    id: 'ann1',
    time: '2021-01-01T00:00:00.000Z',
    label: 'Manual annotation point'
  }, {
    type: 'query_point_event_annotation',
    id: 'ann2',
    filter: {
      type: 'kibana_query',
      language: 'kql',
      query: 'a: *'
    },
    label: 'Query annotation point'
  }]
};
const sampleReferenceLineLayer = exports.sampleReferenceLineLayer = {
  layerId: 'first',
  type: 'referenceLineLayer',
  layerType: _constants.LayerTypes.REFERENCELINE,
  accessors: ['b', 'c'],
  columnToLabel: '{"b": "Label B", "c": "Label C"}',
  decorations: [],
  table: createSampleDatatableWithRows([])
};
const sampleLayer = exports.sampleLayer = {
  layerId: 'first',
  type: 'dataLayer',
  layerType: _constants.LayerTypes.DATA,
  showLines: true,
  seriesType: 'line',
  xAccessor: 'c',
  accessors: ['a', 'b'],
  splitAccessors: ['d'],
  columnToLabel: '{"a": "Label A", "b": "Label B", "d": "Label D"}',
  xScaleType: 'time',
  isHistogram: false,
  isHorizontal: false,
  isPercentage: false,
  isStacked: false,
  palette: mockPaletteOutput,
  table: createSampleDatatableWithRows([])
};
const sampleExtendedLayer = exports.sampleExtendedLayer = {
  layerId: 'first',
  type: 'extendedDataLayer',
  layerType: _constants.LayerTypes.DATA,
  seriesType: 'line',
  xAccessor: 'c',
  accessors: ['a', 'b'],
  splitAccessors: ['d'],
  columnToLabel: '{"a": "Label A", "b": "Label B", "d": "Label D"}',
  xScaleType: 'ordinal',
  isHistogram: false,
  isHorizontal: false,
  isStacked: false,
  isPercentage: false,
  palette: mockPaletteOutput,
  table: createSampleDatatableWithRows([])
};
const createArgsWithLayers = (layers = sampleLayer) => ({
  showTooltip: true,
  minBarHeight: 1,
  legend: {
    type: 'legendConfig',
    isVisible: false,
    position: _charts.Position.Top
  },
  valueLabels: 'hide',
  xAxisConfig: {
    type: 'xAxisConfig',
    position: 'bottom',
    showGridLines: true,
    labelsOrientation: 0,
    showLabels: true,
    showTitle: true,
    title: ''
  },
  yAxisConfigs: [{
    type: 'yAxisConfig',
    position: 'right',
    showGridLines: false,
    labelsOrientation: -45,
    showLabels: false,
    showTitle: true,
    title: '',
    extent: {
      mode: 'full',
      type: 'axisExtentConfig'
    }
  }, {
    type: 'yAxisConfig',
    position: 'left',
    showGridLines: false,
    labelsOrientation: -90,
    showLabels: false,
    showTitle: true,
    title: '',
    extent: {
      mode: 'full',
      type: 'axisExtentConfig'
    }
  }],
  layers: Array.isArray(layers) ? layers : [layers],
  annotations: {
    type: 'event_annotations_result',
    layers: [],
    datatable: {
      type: 'datatable',
      columns: [],
      rows: []
    }
  }
});
exports.createArgsWithLayers = createArgsWithLayers;
function sampleArgs() {
  const data = createSampleDatatableWithRows([{
    a: 1,
    b: 2,
    c: 1652034840000,
    d: 'Foo'
  }, {
    a: 1,
    b: 5,
    c: 1652122440000,
    d: 'Bar'
  }]);
  return {
    data,
    args: createArgsWithLayers({
      ...sampleLayer,
      table: data
    })
  };
}