"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.computeScale = computeScale;
exports.withAutoScale = withAutoScale;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _with_auto_scale = require("./with_auto_scale.styles");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/chart_expressions/expression_legacy_metric/public/components/with_auto_scale.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const MAX_SCALE = 1;
const MIN_SCALE = 0.3;

/**
 * computeScale computes the ratio by which the child needs to shrink in order
 * to fit into the parent. This function is only exported for testing purposes.
 */
function computeScale(parent, child, minScale = MIN_SCALE) {
  if (!parent || !child) {
    return 1;
  }
  const scaleX = parent.clientWidth / child.clientWidth;
  const scaleY = parent.clientHeight / child.clientHeight;
  return Math.max(Math.min(MAX_SCALE, Math.min(scaleX, scaleY)), minScale);
}
function hasAutoscaleProps(props) {
  if (props.autoScaleParams) {
    return true;
  }
  return false;
}
function getWrappedComponentProps(props) {
  if (hasAutoscaleProps(props)) {
    return {
      ...props,
      autoScaleParams: undefined,
      renderComplete: undefined
    };
  }
  return props;
}
function withAutoScale(WrappedComponent) {
  return props => {
    const {
      autoScaleParams,
      renderComplete
    } = props;
    const restProps = getWrappedComponentProps(props);
    // An initial scale of 0 means we always redraw
    // at least once, which is sub-optimal, but it
    // prevents an annoying flicker.
    const [scale, setScale] = (0, _react.useState)(0);
    const [resized, setResized] = (0, _react.useState)(false);
    const parentRef = (0, _react.useRef)(null);
    const childrenRef = (0, _react.useRef)(null);
    const parentDimensions = (0, _eui.useResizeObserver)(parentRef.current);
    const scaleFn = (0, _react.useMemo)(() => (0, _lodash.throttle)(() => {
      const newScale = computeScale({
        clientHeight: parentDimensions.height,
        clientWidth: parentDimensions.width
      }, childrenRef.current, autoScaleParams === null || autoScaleParams === void 0 ? void 0 : autoScaleParams.minScale);

      // Prevent an infinite render loop
      if (scale !== newScale) {
        setScale(newScale);
      }
      if (parentDimensions.height && parentDimensions.width) {
        setResized(true);
      }
    }), [parentDimensions, setScale, scale, autoScaleParams]);
    (0, _react.useEffect)(() => {
      scaleFn();
    }, [scaleFn]);
    (0, _react.useLayoutEffect)(() => {
      if (resized) {
        renderComplete === null || renderComplete === void 0 ? void 0 : renderComplete();
      }
    }, [renderComplete, resized]);
    return /*#__PURE__*/_react.default.createElement("div", {
      ref: parentRef,
      style: autoScaleParams === null || autoScaleParams === void 0 ? void 0 : autoScaleParams.containerStyles,
      css: _with_auto_scale.autoScaleWrapperStyle,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 115,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement("div", {
      ref: childrenRef,
      style: {
        transform: `scale(${scale || 0})`,
        ...(parentDimensions.width && scale && autoScaleParams !== null && autoScaleParams !== void 0 && autoScaleParams.autoScaleMetricAlignment && (autoScaleParams === null || autoScaleParams === void 0 ? void 0 : autoScaleParams.autoScaleMetricAlignment) !== 'center' ? {
          position: 'relative',
          [autoScaleParams.autoScaleMetricAlignment]: (1 - scale) * parentDimensions.width * scale * -1 // The difference of width after scaled
        } : {})
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 116,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(WrappedComponent, (0, _extends2.default)({}, restProps, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 132,
        columnNumber: 11
      }
    }))));
  };
}