"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.esqlCommandRegistry = void 0;
var _registry = require("./registry");
var _limit = require("./commands/limit");
var _drop = require("./commands/drop");
var _keep = require("./commands/keep");
var _fork = require("./commands/fork");
var _rename = require("./commands/rename");
var _change_point = require("./commands/change_point");
var _completion = require("./commands/completion");
var _dissect = require("./commands/dissect");
var _enrich = require("./commands/enrich");
var _eval = require("./commands/eval");
var _from = require("./commands/from");
var _grok = require("./commands/grok");
var _join = require("./commands/join");
var _mv_expand = require("./commands/mv_expand");
var _row = require("./commands/row");
var _sort = require("./commands/sort");
var _stats = require("./commands/stats");
var _inlinestats = require("./commands/inlinestats");
var _sample = require("./commands/sample");
var _show = require("./commands/show");
var _timeseries = require("./commands/timeseries");
var _where = require("./commands/where");
var _fuse = require("./commands/fuse");
var _rerank = require("./commands/rerank");
var _elastisearch_command_data_loader = require("./elastisearch_command_data_loader");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const esqlCommandRegistry = exports.esqlCommandRegistry = new _registry.CommandRegistry();
const baseCommands = [_limit.limitCommand, _drop.dropCommand, _fork.forkCommand, _rename.renameCommand, _change_point.changePointCommand, _completion.completionCommand, _dissect.dissectCommand, _enrich.enrichCommand, _eval.evalCommand, _from.fromCommand, _grok.grokCommand, _join.joinCommand, _mv_expand.mvExpandCommand, _keep.keepCommand, _row.rowCommand, _sort.sortCommand, _stats.statsCommand, _inlinestats.inlineStatsCommand, _sample.sampleCommand, _show.showCommand, _timeseries.timeseriesCommand, _where.whereCommand, _fuse.fuseCommand, _rerank.rerankCommand];
baseCommands.forEach(command => {
  const mergedCommand = (0, _elastisearch_command_data_loader.mergeCommandWithGeneratedCommandData)(command);
  esqlCommandRegistry.registerCommand(mergedCommand);
});