"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.deleteIngestPipelines = deleteIngestPipelines;
exports.deleteLatestIngestPipeline = deleteLatestIngestPipeline;
var _retry = require("./helpers/retry");
var _generate_component_id = require("./helpers/generate_component_id");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function deleteIngestPipelines(esClient, definition, logger) {
  try {
    var _definition$installed;
    await Promise.all(((_definition$installed = definition.installedComponents) !== null && _definition$installed !== void 0 ? _definition$installed : []).filter(({
      type
    }) => type === 'ingest_pipeline').map(({
      id
    }) => (0, _retry.retryTransientEsErrors)(() => esClient.ingest.deletePipeline({
      id
    }, {
      ignore: [404]
    }))));
  } catch (e) {
    logger.error(`Unable to delete ingest pipelines for definition [${definition.id}]: ${e}`);
    throw e;
  }
}
async function deleteLatestIngestPipeline(esClient, definition, logger) {
  try {
    await (0, _retry.retryTransientEsErrors)(() => esClient.ingest.deletePipeline({
      id: (0, _generate_component_id.generateLatestIngestPipelineId)(definition)
    }, {
      ignore: [404]
    }));
  } catch (e) {
    logger.error(`Unable to delete latest ingest pipeline [${definition.id}]: ${e}`);
    throw e;
  }
}